/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.log.Log;
import com.caucho.server.connection.AbstractResponseStream;
import com.caucho.util.L10N;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.i18n.EncodingWriter;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.logging.Logger;

public abstract class ToByteResponseStream
extends AbstractResponseStream {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/connection/ToByteResponseStream"));
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/connection/ToByteResponseStream"));
    protected static final int SIZE = TempBuffer.SIZE;
    private final char[] _charBuffer = new char[SIZE];
    private int _charLength;
    private TempBuffer _head = TempBuffer.allocate();
    private TempBuffer _tail;
    private byte[] _byteBuffer;
    private int _byteLength;
    private int _bufferCapacity;
    private int _bufferSize;
    private boolean _autoFlush;
    private boolean _isHead;
    private boolean _isClosed;
    protected boolean _isFinished;
    private EncodingWriter _toByte;

    protected abstract void writeNext(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected ToByteResponseStream() {
    }

    public void start() {
        this._head.clear();
        this._tail = this._head;
        this._byteBuffer = this._tail.getBuffer();
        this._byteLength = 0;
        this._charLength = 0;
        this._bufferCapacity = SIZE;
        this._bufferSize = 0;
        this._autoFlush = true;
        this._isHead = false;
        this._isClosed = false;
        this._isFinished = false;
        this._toByte = Encoding.getWriteEncoding("ISO-8859-1");
    }

    public boolean isCauchoResponseStream() {
        return true;
    }

    public void setHead() {
        this._isHead = true;
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this._toByte = Encoding.getWriteEncoding(encoding);
        if (this._toByte == null) {
            throw new UnsupportedEncodingException(encoding);
        }
    }

    public void setLocale(Locale locale) throws UnsupportedEncodingException {
    }

    public char[] getCharBuffer() {
        return this._charBuffer;
    }

    public int getCharOffset() {
        return this._charLength;
    }

    public void setCharOffset(int offset) {
        this._charLength = offset;
    }

    public byte[] getBuffer() {
        return this._byteBuffer;
    }

    public int getBufferOffset() {
        return this._byteLength;
    }

    public void setBufferOffset(int offset) throws IOException {
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        this._byteLength = offset;
    }

    public int getBufferSize() {
        return this._bufferCapacity;
    }

    public void setBufferSize(int size) {
        this._bufferCapacity = SIZE * ((size + SIZE - 1) / SIZE);
        if (this._bufferCapacity <= 0) {
            this._bufferCapacity = 0;
        }
    }

    public int getRemaining() {
        return this._bufferCapacity - this.getBufferLength();
    }

    protected int getBufferLength() {
        return this._bufferSize + this._byteLength + this._charLength;
    }

    public void clearBuffer() {
        TempBuffer.freeAll(this._head.getNext());
        this._head.clear();
        this._tail = this._head;
        this._byteBuffer = this._tail.getBuffer();
        this._byteLength = 0;
        this._charLength = 0;
        this._bufferSize = 0;
    }

    public void write(int ch) throws IOException {
        if (this._isClosed) {
            return;
        }
        if (this._isHead) {
            return;
        }
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + this._byteLength + 1) {
            if (this._bufferSize + this._byteLength > 0) {
                this.flushByteBuffer();
            }
        } else if (this._byteLength == SIZE) {
            this._tail.setLength(this._byteLength);
            this._bufferSize += this._byteLength;
            TempBuffer tempBuf = TempBuffer.allocate();
            this._tail.setNext(tempBuf);
            this._tail = tempBuf;
            this._byteBuffer = this._tail.getBuffer();
            this._byteLength = 0;
        }
        this._byteBuffer[this._byteLength++] = (byte)ch;
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        boolean isFinished = false;
        if (this._isClosed) {
            return;
        }
        if (this._isHead) {
            return;
        }
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        if (this._bufferCapacity <= this._bufferSize + this._byteLength + length) {
            if (this._bufferSize + this._byteLength > 0) {
                this.flushByteBuffer();
            }
            if (this._bufferCapacity <= length) {
                this._bufferSize = length;
                this.writeNext(buffer, offset, length, isFinished);
                this._bufferSize = 0;
                return;
            }
        }
        int byteLength = this._byteLength;
        while (length > 0) {
            int sublen;
            if (SIZE <= byteLength) {
                this._tail.setLength(byteLength);
                this._bufferSize += byteLength;
                TempBuffer tempBuf = TempBuffer.allocate();
                this._tail.setNext(tempBuf);
                this._tail = tempBuf;
                this._byteBuffer = this._tail.getBuffer();
                byteLength = 0;
            }
            if (SIZE - byteLength < (sublen = length)) {
                sublen = SIZE - byteLength;
            }
            System.arraycopy(buffer, offset, this._byteBuffer, byteLength, sublen);
            offset += sublen;
            length -= sublen;
            byteLength += sublen;
        }
        this._byteLength = byteLength;
    }

    public void print(int ch) throws IOException {
        if (this._isClosed) {
            return;
        }
        if (this._isHead) {
            return;
        }
        if (this._charLength == SIZE) {
            this.flushCharBuffer();
        }
        this._charBuffer[this._charLength++] = (char)ch;
    }

    public void print(char[] buffer, int offset, int length) throws IOException {
        if (this._isClosed) {
            return;
        }
        if (this._isHead) {
            return;
        }
        int charLength = this._charLength;
        while (length > 0) {
            int sublen;
            if (charLength == SIZE) {
                this._charLength = charLength;
                charLength = 0;
                this.flushCharBuffer();
            }
            if (length < (sublen = SIZE - charLength)) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._charBuffer, charLength, sublen);
            offset += sublen;
            length -= sublen;
            charLength += sublen;
        }
        this._charLength = charLength;
    }

    public void flushBuffer() throws IOException {
        if (this._charLength > 0) {
            this.flushCharBuffer();
        }
        this.flushByteBuffer();
    }

    public void flush() throws IOException {
        this.flushBuffer();
    }

    public void close() throws IOException {
        this.flushBuffer();
        this._isClosed = true;
    }

    public char[] nextCharBuffer(int offset) throws IOException {
        this._charLength = offset;
        this.flushCharBuffer();
        return this._charBuffer;
    }

    protected void flushCharBuffer() throws IOException {
        int charLength = this._charLength;
        this._charLength = 0;
        this._toByte.write(this, this._charBuffer, 0, charLength);
        if (this._bufferCapacity <= this._byteLength + this._bufferSize) {
            this.flushByteBuffer();
        }
    }

    public byte[] nextBuffer(int offset) throws IOException {
        if (this._byteLength + this._bufferSize < this._bufferCapacity) {
            this._tail.setLength(offset);
            this._bufferSize += offset;
            TempBuffer tempBuf = TempBuffer.allocate();
            this._tail.setNext(tempBuf);
            this._tail = tempBuf;
            this._byteBuffer = this._tail.getBuffer();
            this._byteLength = 0;
        } else {
            this._byteLength = offset;
            this.flushByteBuffer();
        }
        return this._byteBuffer;
    }

    protected void flushByteBuffer() throws IOException {
        TempBuffer next;
        this._tail.setLength(this._byteLength);
        this._bufferSize += this._byteLength;
        this._byteLength = 0;
        TempBuffer ptr = this._head;
        do {
            this._head = ptr;
            next = ptr.getNext();
            ptr.setNext(null);
            this.writeNext(ptr.getBuffer(), 0, ptr.getLength(), this._isFinished);
            if (next == null) continue;
            TempBuffer.free(ptr);
        } while ((ptr = next) != null);
        this._tail = this._head;
        this._byteBuffer = this._tail.getBuffer();
        this._bufferSize = 0;
    }

    public void clearClose() {
        this._isClosed = false;
    }
}

