/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.connection;

import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.connection.CauchoResponse;
import com.caucho.server.connection.RequestWrapper;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.Application;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestAdapter
extends RequestWrapper
implements CauchoRequest {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/connection/RequestAdapter"));
    static final int MAX_DEPTH = 64;
    public static String REQUEST_URI = "javax.servlet.include.request_uri";
    public static String CONTEXT_PATH = "javax.servlet.include.context_path";
    public static String SERVLET_PATH = "javax.servlet.include.servlet_path";
    public static String PATH_INFO = "javax.servlet.include.path_info";
    public static String QUERY_STRING = "javax.servlet.include.query_string";
    public static String STATUS_CODE = "javax.servlet.error.status_code";
    public static String EXCEPTION_TYPE = "javax.servlet.error.exception_type";
    public static String MESSAGE = "javax.servlet.error.message";
    public static String EXCEPTION = "javax.servlet.error.exception";
    public static String ERROR_URI = "javax.servlet.error.request_uri";
    public static String SERVLET_NAME = "javax.servlet.error.servlet_name";
    public static String JSP_EXCEPTION = "javax.servlet.jsp.jspException";
    public static String SHUTDOWN = "com.caucho.shutdown";
    private static final FreeList<RequestAdapter> _freeList = new FreeList(16);
    private Application _application;
    private HttpServletResponse _response;
    private HashMap<String, String> _roleMap;

    protected RequestAdapter() {
        super(null);
    }

    protected RequestAdapter(HttpServletRequest request, Application app) {
        super(request);
        this._application = app;
    }

    public static RequestAdapter create(HttpServletRequest request, Application app) {
        RequestAdapter reqAdapt = _freeList.allocate();
        if (reqAdapt == null) {
            return new RequestAdapter(request, app);
        }
        reqAdapt.setRequest(request);
        reqAdapt._application = app;
        return reqAdapt;
    }

    public static RequestAdapter create() {
        RequestAdapter reqAdapt = _freeList.allocate();
        if (reqAdapt != null) {
            return reqAdapt;
        }
        return new RequestAdapter();
    }

    public void init(HttpServletRequest request, HttpServletResponse response, Application app) throws ServletException {
        this.setRequest(request);
        this._response = response;
        this._application = app;
        if (request == this || request instanceof CauchoRequest && ((CauchoRequest)request).getRequestDepth(0) > 64) {
            throw new ServletException(L.l("too many servlet includes `{0}'", request.getRequestURI()));
        }
    }

    @Override
    public boolean isTop() {
        return false;
    }

    public void setApplication(Application app) {
        this._application = app;
    }

    protected HttpServletResponse getResponse() {
        return this._response;
    }

    public void setResponse(CauchoResponse response) {
        this._response = response;
    }

    @Override
    public ReadStream getStream() throws IOException {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getStream();
        }
        return null;
    }

    @Override
    public String getPageURI() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return uri;
        }
        return this.getRequestURI();
    }

    public static String getPageURI(HttpServletRequest request) {
        String uri = (String)request.getAttribute(REQUEST_URI);
        if (uri != null) {
            return uri;
        }
        return request.getRequestURI();
    }

    @Override
    public String getPageContextPath() {
        String contextPath = (String)this.getAttribute(CONTEXT_PATH);
        if (contextPath != null) {
            return contextPath;
        }
        return this.getContextPath();
    }

    public static String getPageContextPath(HttpServletRequest request) {
        String contextPath = (String)request.getAttribute(CONTEXT_PATH);
        if (contextPath != null) {
            return contextPath;
        }
        return request.getContextPath();
    }

    @Override
    public String getPageServletPath() {
        String servletPath = (String)this.getAttribute(SERVLET_PATH);
        if (servletPath != null) {
            return servletPath;
        }
        return this.getServletPath();
    }

    public static String getPageServletPath(HttpServletRequest request) {
        String servletPath = (String)request.getAttribute(SERVLET_PATH);
        if (servletPath != null) {
            return servletPath;
        }
        return request.getServletPath();
    }

    @Override
    public String getPagePathInfo() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(PATH_INFO);
        }
        return this.getPathInfo();
    }

    public static String getPagePathInfo(HttpServletRequest request) {
        String uri = (String)request.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)request.getAttribute(PATH_INFO);
        }
        return request.getPathInfo();
    }

    @Override
    public String getPageQueryString() {
        String uri = (String)this.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)this.getAttribute(QUERY_STRING);
        }
        return this.getQueryString();
    }

    public static String getPageQueryString(HttpServletRequest request) {
        String uri = (String)request.getAttribute(REQUEST_URI);
        if (uri != null) {
            return (String)request.getAttribute(QUERY_STRING);
        }
        return request.getQueryString();
    }

    @Override
    public int getRequestDepth(int depth) {
        if (depth > 64) {
            throw new RuntimeException(L.l("too many request dispatchers"));
        }
        HttpServletRequest req = this.getRequest();
        while (req != null) {
            if (req instanceof CauchoRequest) {
                return ((CauchoRequest)req).getRequestDepth(depth + 1);
            }
            if (!(req instanceof ServletRequestWrapper)) break;
            ServletRequestWrapper reqWrap = (ServletRequestWrapper)req;
            req = reqWrap.getRequest();
        }
        return depth + 2;
    }

    @Override
    public void setHeader(String key, String value) {
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public void setVaryCookie(String cookie) {
        if (this.getRequest() instanceof CauchoRequest) {
            ((CauchoRequest)this.getRequest()).setVaryCookie(cookie);
        }
    }

    @Override
    public String getVaryCookie() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getVaryCookie();
        }
        return null;
    }

    @Override
    public boolean getVaryCookies() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getVaryCookies();
        }
        return false;
    }

    @Override
    public void setHasCookie() {
        if (this.getRequest() instanceof CauchoRequest) {
            ((CauchoRequest)this.getRequest()).setHasCookie();
        }
    }

    @Override
    public boolean getHasCookie() {
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getHasCookie();
        }
        return false;
    }

    @Override
    public HttpSession getSession(boolean create) {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        HttpSession session = super.getSession(create);
        if (session != null) {
            this.setHasCookie();
        }
        return session;
    }

    @Override
    public String getRequestedSessionId() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        String id = super.getRequestedSessionId();
        if (id != null) {
            this.setHasCookie();
        }
        return id;
    }

    @Override
    public boolean isRequestedSessionIdValid() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = super.isRequestedSessionIdValid();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    @Override
    public boolean isRequestedSessionIdFromCookie() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = super.isRequestedSessionIdFromCookie();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    @Override
    public boolean isRequestedSessionIdFromURL() {
        SessionManager manager = this.getSessionManager();
        this.setVaryCookie(manager.getCookieName());
        boolean isValid = super.isRequestedSessionIdFromURL();
        if (isValid) {
            this.setHasCookie();
        }
        return isValid;
    }

    protected SessionManager getSessionManager() {
        Application app = this.getApplication();
        if (app != null) {
            return app.getSessionManager();
        }
        return null;
    }

    @Override
    public Cookie[] getCookies() {
        this.setVaryCookie(null);
        Cookie[] cookies = super.getCookies();
        if (cookies != null && cookies.length > 0) {
            this.setHasCookie();
        }
        return cookies;
    }

    @Override
    public Cookie getCookie(String name) {
        this.setVaryCookie(name);
        if (this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getCookie(name);
        }
        Cookie[] cookies = super.getCookies();
        for (int i = 0; i < cookies.length; ++i) {
            if (!cookies[i].getName().equals(name)) continue;
            this.setHasCookie();
            return cookies[i];
        }
        return null;
    }

    @Override
    public void killKeepalive() {
    }

    @Override
    public boolean allowKeepalive() {
        return true;
    }

    @Override
    public HashMap<String, String> setRoleMap(HashMap<String, String> map) {
        HashMap<String, String> oldMap = this._roleMap;
        this._roleMap = map;
        return oldMap;
    }

    @Override
    public boolean isUserInRole(String role) {
        String newRole;
        if (this._roleMap != null && (newRole = this._roleMap.get(role)) != null) {
            role = newRole;
        }
        return super.isUserInRole(role);
    }

    @Override
    public boolean authenticate() throws ServletException, IOException {
        return true;
    }

    public static void free(RequestAdapter reqAdapt) {
        reqAdapt.free();
        _freeList.free(reqAdapt);
    }

    @Override
    protected void free() {
        super.free();
        this._application = null;
        this._response = null;
    }
}

