/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

public class Store {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/Store"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/Store"));
    private StoreManager _storeManager;
    private ObjectManager _objectManager;
    private String _storeId;

    Store(String storeId, StoreManager storeManager) {
        this._storeId = Store.mangleId(storeId);
        this._storeManager = storeManager;
    }

    public String getId() {
        return this._storeId;
    }

    public ObjectManager getObjectManager() {
        return this._objectManager;
    }

    public void setObjectManager(ObjectManager obj) {
        this._objectManager = obj;
    }

    public long getMaxIdleTime() {
        return this._storeManager.getMaxIdleTime();
    }

    public ClusterObject createClusterObject(String objectId) {
        return this._storeManager.createClusterObject(this, objectId);
    }

    public void access(String objectId) throws Exception {
        this._storeManager.access(this, objectId);
    }

    public void remove(String objectId) throws Exception {
        this._storeManager.remove(this, objectId);
    }

    void notifyRemove(String objectId) throws Exception {
        if (this._objectManager != null) {
            this._objectManager.notifyRemove(objectId);
        }
    }

    private static String mangleId(String id) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < id.length(); ++i) {
            char ch = id.charAt(i);
            if (ch == '/') {
                cb.append("__");
                continue;
            }
            if (ch == ':') {
                cb.append("_0");
                continue;
            }
            if (ch == '_') {
                cb.append("_1");
                continue;
            }
            cb.append(ch);
        }
        return cb.close();
    }
}

