/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.DistributedObject;
import com.caucho.server.cluster.Store;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ObjectBacking {
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ObjectBacking"));
    private Path _objectPath;
    private Store _store;
    private String _id;
    private DistributedObject _object;

    public ObjectBacking(String id, Path objectPath, Store store) {
        this._id = id;
        this._store = store;
        this._objectPath = objectPath;
    }

    public String getId() {
        return this._id;
    }

    public Path getPath() {
        return this._objectPath;
    }

    public DistributedObject getObject() {
        return this._object;
    }

    public void setObject(DistributedObject object) {
        this._object = object;
    }

    public ReadStream openRead() throws IOException {
        return this._objectPath.openRead();
    }

    public WriteStream openWrite() throws IOException {
        return this._objectPath.openWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void save(DistributedObject object) {
        WriteStream os = null;
        try {
            os = this._objectPath.openWrite();
            this._object = object;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public synchronized void remove() {
        try {
            this._objectPath.remove();
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean canLog() {
        return log.isLoggable(Level.FINE);
    }

    public void log(String value) {
        log.fine(value);
    }

    public String toString() {
        return "DistBacking[" + this._objectPath + "]";
    }
}

