/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.server.cluster.ClusterObject;
import com.caucho.server.cluster.FileObject;
import com.caucho.server.cluster.SharedFileObject;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.Alarm;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.logging.Level;

public class FileStore
extends StoreManager {
    protected Path _path;

    public void setPath(Path path) {
        this._path = path;
    }

    public void addText(String value) {
        this._path = Vfs.lookup(value.trim());
    }

    public Path getPath() {
        return this._path;
    }

    public void clearOldObjects() {
        this.clearOldObjects(this.getPath(), Alarm.getCurrentTime());
    }

    public void clearOldObjects(Path dir, long now) {
        try {
            String[] list = dir.list();
            for (int i = 0; list != null && i < list.length; ++i) {
                Path path = dir.lookup(list[i]);
                if (path.isFile() && path.canRead()) {
                    long lastModified = path.getLastModified();
                    if (lastModified + this._maxIdleTime >= now) continue;
                    log.finer("timeout file: " + path);
                    path.remove();
                    continue;
                }
                if (!path.isDirectory()) continue;
                this.clearOldObjects(path, now);
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    ClusterObject create(Store store, String id) {
        return new SharedFileObject((StoreManager)this, store, id, this.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(ClusterObject clusterObj, Object obj) throws Exception {
        FileObject fileObj = (FileObject)clusterObj;
        ReadStream is = null;
        try {
            is = fileObj.openRead();
            if (log.isLoggable(Level.FINE)) {
                log.fine("load file: " + fileObj.getPath());
            }
            boolean bl = clusterObj.load(is, obj);
            return bl;
        }
        catch (IOException e) {
            log.fine("no saved object: " + e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(ClusterObject obj, TempStream is, long crc, int updateCount) throws Exception {
        block9: {
            FileObject fileObj = (FileObject)obj;
            WriteStream os = null;
            try {
                os = fileObj.openWrite();
                ReadStream rs = is.openRead();
                os.writeStream(rs);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("store file: " + fileObj.getPath());
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
                if (os == null) break block9;
                try {
                    os.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
                os = null;
            }
            finally {
                if (os != null) {
                    os.close();
                }
            }
        }
    }

    public void remove(ClusterObject obj) throws Exception {
        this.removeClusterObject(obj.getStoreId(), obj.getObjectId());
        obj.removeImpl();
        if (log.isLoggable(Level.FINE)) {
            log.fine("remove file-store session: " + obj);
        }
    }
}

