/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.server.hmux.HmuxProtocol;
import com.caucho.server.http.SrunProtocol;
import com.caucho.server.port.Port;
import com.caucho.server.port.Protocol;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;

public class ClusterPort
extends Port {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterPort"));
    private int _index = -1;
    private boolean _isBackup;
    private String _protocolName = "hmux";

    public void setProtocol(Protocol protocol) throws ConfigException {
        if (!protocol.getClass().equals(ClassLiteral.getClass((String)"com/caucho/server/port/Protocol"))) {
            super.setProtocol(protocol);
        } else if (protocol.getProtocolName().equals("srun")) {
            this._protocolName = "srun";
        } else if (protocol.getProtocolName().equals("hmux")) {
            this._protocolName = "hmux";
        } else {
            throw new ConfigException(L.l("`{0}' is an unknown cluster protocol.  The protocol must be:\n hmux - new Resin P2P cluster protocol\n srun - old Resin protocol", protocol.getProtocolName()));
        }
    }

    public String getClusterProtocol() {
        return this._protocolName;
    }

    public void setIndex(int index) {
        this._index = index - 1;
    }

    public int getIndex() {
        return this._index;
    }

    public void setBackup(boolean isBackup) {
        this._isBackup = isBackup;
    }

    public boolean isBackup() {
        return this._isBackup;
    }

    public void init() throws ConfigException {
        if (this.getProtocol() == null || this.getProtocol().getClass().equals(ClassLiteral.getClass((String)"com/caucho/server/port/Protocol"))) {
            if (this.getClusterProtocol().equals("srun")) {
                SrunProtocol protocol = new SrunProtocol();
                protocol.setParent(this);
                this.setProtocol(protocol);
            } else if (this.getClusterProtocol().equals("hmux")) {
                HmuxProtocol protocol = new HmuxProtocol();
                protocol.setParent(this);
                this.setProtocol(protocol);
            } else {
                throw new ConfigException(L.l("`{0}' is an unknown protocol.", this.getClusterProtocol()));
            }
        }
        super.init();
    }

    public String toString() {
        if (this.getHost() == null) {
            return "ClusterPort[host=*,port=" + this.getPort() + "]";
        }
        return "ClusterPort[host=" + this.getHost() + ",port=" + this.getPort() + "]";
    }
}

