/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ObjectManager;
import com.caucho.server.cluster.Store;
import com.caucho.server.cluster.StoreManager;
import com.caucho.util.Alarm;
import com.caucho.vfs.Crc64Stream;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterObject {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterObject"));
    private final StoreManager _storeManager;
    private final Store _store;
    private final String _storeId;
    private final ObjectManager _objectManager;
    private final String _objectId;
    private final String _uniqueId;
    private boolean _isPrimary;
    private long _accessTime;
    private long _crc = -1L;
    private int _updateCount = -1;
    private boolean _isSerializable = true;
    private boolean _isChanged = false;
    private boolean _isDead = false;

    ClusterObject(StoreManager storeManager, Store store, String objectId) {
        this._storeManager = storeManager;
        this._objectManager = store.getObjectManager();
        this._store = store;
        this._storeId = store.getId();
        this._objectId = objectId;
        this._uniqueId = this._storeId + ';' + objectId;
        this._isPrimary = this.isPrimary(this._objectId);
    }

    ClusterObject(StoreManager storeManager, String storeId, String objectId) {
        this._storeManager = storeManager;
        this._objectManager = null;
        this._store = null;
        this._storeId = storeId;
        this._objectId = objectId;
        this._uniqueId = this._storeId + ';' + objectId;
        this._isPrimary = this.isPrimary(this._objectId);
    }

    private boolean isPrimary(String id) {
        Cluster cluster = Cluster.getLocal();
        ClusterServer selfServer = cluster.getSelfServer();
        if (selfServer == null) {
            return !this._storeManager.isAlwaysLoad();
        }
        return this._storeManager.getOwnerIndex(id) == selfServer.getIndex();
    }

    public Store getStore() {
        return this._store;
    }

    public StoreManager getStoreManager() {
        return this._storeManager;
    }

    public String getStoreId() {
        return this._storeId;
    }

    public String getObjectId() {
        return this._objectId;
    }

    public String getUniqueId() {
        return this._uniqueId;
    }

    public void setPrimary(boolean primary) {
        this._isPrimary = primary;
    }

    long getCRC() {
        return this._crc;
    }

    void setCRC(long crc) {
        this._crc = crc;
    }

    int getUpdateCount() {
        return this._updateCount;
    }

    void setUpdateCount(int count) {
        this._updateCount = count;
    }

    public boolean load(Object obj) {
        if (!this._isSerializable) {
            return true;
        }
        if (this._isDead) {
            throw new IllegalStateException();
        }
        if (this._isPrimary && this._updateCount >= 0) {
            return true;
        }
        try {
            if (this._storeManager.load(this, obj)) {
                return true;
            }
            this._crc = -1L;
            return false;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            this._crc = -1L;
            return false;
        }
    }

    boolean load(InputStream is, Object obj) throws IOException {
        VfsStream streamImpl = new VfsStream(is, null);
        Crc64Stream crcStream = new Crc64Stream(streamImpl);
        ReadStream crcIs = new ReadStream(crcStream);
        DistributedObjectInputStream in = new DistributedObjectInputStream(crcIs);
        this._objectManager.load(in, obj);
        this._crc = crcStream.getCRC();
        in.close();
        crcIs.close();
        return true;
    }

    public void update() {
        this._updateCount = -1;
    }

    public void change() {
        if (!this._isChanged) {
            ++this._updateCount;
        }
        this._isChanged = true;
    }

    public void access() {
        long now = Alarm.getCurrentTime();
        if (600000L <= now - this._accessTime) {
            try {
                this._storeManager.accessImpl(this._storeId, this._objectId);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            this._accessTime = now;
        }
    }

    public void setAccessTime(long accessTime) {
        this._accessTime = accessTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(Object obj) throws IOException {
        if (!this._isSerializable) {
            return;
        }
        int updateCount = this._updateCount;
        if (!this._isPrimary) {
            this._updateCount = -1;
        }
        if (!this._isChanged && !this._storeManager.isAlwaysSave()) {
            return;
        }
        this._isChanged = false;
        TempStream tempStream = new TempStream(null);
        Crc64Stream crcStream = new Crc64Stream(tempStream);
        try {
            WriteStream os = new WriteStream(crcStream);
            ObjectOutputStream out = new ObjectOutputStream(os);
            this._objectManager.store(out, obj);
            out.flush();
            long crc = crcStream.getCRC();
            out.close();
            os.close();
            os = null;
            if (crc == this._crc) {
                return;
            }
            this._crc = crc;
            this._storeManager.store(this, tempStream, crc, ++updateCount);
            if (this._isPrimary) {
                this._updateCount = updateCount;
            }
            this._accessTime = Alarm.getCurrentTime();
        }
        catch (NotSerializableException e) {
            log.warning(e.toString());
            this._isSerializable = false;
        }
        catch (Throwable e) {
            log.warning(e.toString());
            log.log(Level.FINE, e.toString(), e);
            this._updateCount = -1;
        }
        finally {
            tempStream.destroy();
        }
    }

    public void write(InputStream is) throws IOException {
    }

    public ReadStream openRead() throws IOException {
        return null;
    }

    public void remove() {
        try {
            if (this._isDead) {
                return;
            }
            this._isDead = true;
            this._storeManager.remove(this);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void removeImpl() {
    }

    static class DistributedObjectInputStream
    extends ObjectInputStream {
        DistributedObjectInputStream(InputStream is) throws IOException {
            super(is);
        }

        protected Class resolveClass(ObjectStreamClass v) throws IOException, ClassNotFoundException {
            String name = v.getName();
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            return Class.forName(name, false, loader);
        }
    }
}

