/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.config.ConfigException;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterPort;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

public class ClusterGroup {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterGroup"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/server/cluster/ClusterGroup"));
    private Cluster _cluster;
    private ClusterServer[] _serverList = new ClusterServer[0];

    public void setCluster(Cluster cluster) {
        this._cluster = cluster;
    }

    public Cluster getCluster() {
        return this._cluster;
    }

    public void addPort(ClusterPort port) throws Exception {
        ClusterServer server = new ClusterServer();
        server.setCluster(this.getCluster());
        server.setGroup(this);
        server.setPort(port);
        if (port.getIndex() < 0) {
            port.setIndex(this.getCluster().getServerList().length + 1);
        }
        server.init();
        this.add(server);
    }

    public void addSrun(ClusterPort port) throws Exception {
        this.addPort(port);
    }

    public ClusterServer[] getServerList() {
        return this._serverList;
    }

    void add(ClusterServer server) throws ConfigException {
        int i;
        int newLength = this._serverList.length + 1;
        ClusterServer[] newList = new ClusterServer[newLength];
        System.arraycopy(this._serverList, 0, newList, 0, this._serverList.length);
        this._serverList = newList;
        for (i = newLength - 1; i > 0; --i) {
            ClusterServer oldServer = this._serverList[i - 1];
            if (oldServer.getIndex() == server.getIndex()) {
                throw new ConfigException(L.l("Cluster server `{0}' conflicts with a previous server.", server.getIndex()));
            }
            if (oldServer.getIndex() < server.getIndex()) break;
            this._serverList[i] = oldServer;
            oldServer.setGroupIndex(i);
        }
        this._serverList[i] = server;
        server.setGroup(this);
        server.setGroupIndex(i);
        this.getCluster().addServer(server);
    }
}

