/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.taglib;

import com.caucho.portal.generic.InvocationURL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUrlTag
extends TagSupport {
    private String _var;
    private WindowState _windowState;
    private PortletMode _portletMode;
    private Boolean _secure;
    private LinkedHashMap<String, Object> _paramMap = new LinkedHashMap();
    private LinkedHashMap<String, LinkedHashMap<String, Object>> _namespaceParamMap = new LinkedHashMap();

    protected abstract PortletURL createPortletURL(RenderResponse var1);

    public void setVar(String var) {
        this._var = var;
    }

    public void setWindowState(String windowState) {
        this._windowState = new WindowState(windowState);
    }

    public void setPortletMode(String portletMode) {
        this._portletMode = new PortletMode(portletMode);
    }

    public void setSecure(String secure) throws JspException {
        if (secure == null) {
            this._secure = null;
        } else if (secure.equalsIgnoreCase("true")) {
            this._secure = Boolean.TRUE;
        } else if (secure.equalsIgnoreCase("false")) {
            this._secure = Boolean.FALSE;
        } else {
            throw new JspException("secure must be `true' or `false' or unspecified");
        }
    }

    public int doStartTag() throws JspException {
        this._paramMap.clear();
        this._namespaceParamMap.clear();
        return 1;
    }

    public void addParam(String name, String value) {
        this.addParam(this._paramMap, name, value);
    }

    public void addParam(String namespace, String name, String value) {
        LinkedHashMap<String, Object> map = this._namespaceParamMap.get(namespace);
        if (map == null) {
            map = new LinkedHashMap();
            this._namespaceParamMap.put(namespace, map);
        }
        this.addParam(map, name, value);
    }

    private void addParam(LinkedHashMap<String, Object> map, String name, String value) {
        Object current = map.put(name, value);
        if (current != null) {
            if (current instanceof ArrayList) {
                ArrayList list = (ArrayList)current;
                list.add(value);
                map.put(name, list);
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add((String)current);
                list.add(value);
                map.put(name, list);
            }
        }
    }

    public int doEndTag() throws JspException {
        ServletRequest request = this.pageContext.getRequest();
        RenderResponse response = (RenderResponse)request.getAttribute("javax.portlet.renderResponse");
        if (response == null) {
            throw new JspException("No RenderResponse available");
        }
        PortletURL url = this.createPortletURL(response);
        if (this._windowState != null) {
            try {
                url.setWindowState(this._windowState);
            }
            catch (WindowStateException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        if (this._portletMode != null) {
            try {
                url.setPortletMode(this._portletMode);
            }
            catch (PortletModeException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        if (this._secure != null) {
            try {
                if (this._secure == Boolean.FALSE) {
                    url.setSecure(false);
                } else {
                    url.setSecure(true);
                }
            }
            catch (PortletSecurityException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        if (this._paramMap.size() > 0) {
            for (Map.Entry<String, Object> entry : this._paramMap.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof String) {
                    url.setParameter(name, (String)value);
                    continue;
                }
                url.setParameter(name, this.makeStringArray((ArrayList)value));
            }
        }
        if (this._namespaceParamMap.size() > 0) {
            InvocationURL invocationUrl = (InvocationURL)url;
            for (Map.Entry<String, LinkedHashMap<String, Object>> entry : this._namespaceParamMap.entrySet()) {
                String namespace = entry.getKey();
                LinkedHashMap<String, Object> map = entry.getValue();
                for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
                    String name = mapEntry.getKey();
                    Object value = mapEntry.getValue();
                    if (value instanceof String) {
                        invocationUrl.setParameter(namespace, name, (String)value);
                        continue;
                    }
                    String[] values = this.makeStringArray((ArrayList)value);
                    invocationUrl.setParameter(namespace, name, values);
                }
            }
        }
        String urlString = url.toString();
        if (this._var != null) {
            this.pageContext.setAttribute(this._var, (Object)urlString);
        } else {
            try {
                this.pageContext.getOut().print(urlString);
            }
            catch (IOException ex) {
                throw new JspException((Throwable)ex);
            }
        }
        return 6;
    }

    private String[] makeStringArray(ArrayList<String> list) {
        int sz = list.size();
        String[] array = new String[sz];
        for (int i = 0; i < sz; ++i) {
            array[i] = list.get(i);
        }
        return array;
    }
}

