/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.context;

import com.caucho.portal.generic.Cache;
import com.caucho.portal.generic.CacheKey;
import com.caucho.portal.generic.context.AbstractResponseHandler;
import com.caucho.portal.generic.context.ResponseHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingResponseHandler
extends AbstractResponseHandler {
    private Cache _cache;
    private String _namespace;
    private int _expirationCache;
    private boolean _isPrivate;
    private Writer _cacheWriter;
    private OutputStream _cacheOutputStream;
    private LinkedHashMap<String, Object> _propertiesMap;
    private LinkedHashMap<String, Object> _cachePropertiesMap;

    public CachingResponseHandler(ResponseHandler responseHandler, Cache cache, String namespace, int expirationCache, boolean isPrivate) {
        super(responseHandler);
        this._cache = cache;
        this._namespace = namespace;
        this._expirationCache = expirationCache;
        this._isPrivate = isPrivate;
    }

    private LinkedHashMap<String, Object> getMapForProperty(String name) {
        if (name.startsWith("Cache-")) {
            if (this._cachePropertiesMap == null) {
                this._cachePropertiesMap = new LinkedHashMap();
            }
            return this._cachePropertiesMap;
        }
        if (this._propertiesMap == null) {
            this._propertiesMap = new LinkedHashMap();
        }
        return this._propertiesMap;
    }

    @Override
    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        LinkedHashMap<String, Object> map = this.getMapForProperty(name);
        map.put(name, value);
    }

    @Override
    public void addProperty(String name, String value) {
        super.addProperty(name, value);
        LinkedHashMap<String, Object> map = this.getMapForProperty(name);
        Object currentValue = map.get(name);
        if (currentValue == null) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            map.put(name, values);
        } else if (currentValue instanceof String) {
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)currentValue);
            values.add(value);
            map.put(name, values);
        } else {
            ArrayList values = (ArrayList)currentValue;
            values.add(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(int expirationCache, CacheKey cacheKey, Map<String, String> requestAttributesMap) throws IOException {
        Cache cache = this._cache;
        OutputStream cacheOutputStream = this._cacheOutputStream;
        Writer cacheWriter = this._cacheWriter;
        this._cacheOutputStream = null;
        this._cacheWriter = null;
        this._cache = null;
        this._namespace = null;
        this._isPrivate = false;
        this._expirationCache = 0;
        String enc = null;
        boolean fail = true;
        try {
            if (cacheWriter != null) {
                enc = this.getCharacterEncoding();
            }
            boolean isError = this.isError();
            super.finish();
            if (!isError) {
                LinkedHashMap<String, Object> cachePropertiesMap = null;
                LinkedHashMap<String, Object> propertiesMap = null;
                if (this._cachePropertiesMap != null && !this._cachePropertiesMap.isEmpty()) {
                    cachePropertiesMap = this._cachePropertiesMap;
                }
                if (this._propertiesMap != null && !this._propertiesMap.isEmpty()) {
                    propertiesMap = this._propertiesMap;
                }
                if (cacheWriter != null) {
                    cache.finishCaching(cacheWriter, expirationCache, cacheKey, enc, cachePropertiesMap, propertiesMap, requestAttributesMap);
                    fail = false;
                }
                if (cacheOutputStream != null) {
                    cache.finishCaching(cacheOutputStream, expirationCache, cacheKey, cachePropertiesMap, propertiesMap, requestAttributesMap);
                    fail = false;
                }
            }
        }
        finally {
            if (fail) {
                if (cacheWriter != null) {
                    cache.finishCaching(cacheWriter, 0, null, null, null, null, null);
                }
                if (cacheOutputStream != null) {
                    cache.finishCaching(cacheOutputStream, 0, null, null, null, null);
                }
            }
        }
    }

    @Override
    public void finish() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getWriter() throws IOException {
        PrintWriter writer = super.getWriter();
        try {
            this._cacheWriter = this._cache.getCachingWriter(this._namespace, this._expirationCache, this._isPrivate);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.toString(), ex);
        }
        return writer;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream outputStream = super.getOutputStream();
        try {
            this._cacheOutputStream = this._cache.getCachingOutputStream(this._namespace, this._expirationCache, this._isPrivate);
        }
        catch (Exception ex) {
            log.log(Level.WARNING, ex.toString(), ex);
        }
        return outputStream;
    }

    @Override
    protected void print(char[] buf, int off, int len) throws IOException {
        super.print(buf, off, len);
        if (this._cacheWriter != null) {
            this._cacheWriter.write(buf, off, len);
        }
    }

    @Override
    protected void print(String str, int off, int len) throws IOException {
        super.print(str, off, len);
        if (this._cacheWriter != null) {
            this._cacheWriter.write(str, off, len);
        }
    }

    @Override
    protected void print(char c) throws IOException {
        super.print(c);
        if (this._cacheWriter != null) {
            this._cacheWriter.write(c);
        }
    }

    @Override
    protected void write(byte[] buf, int off, int len) throws IOException {
        super.write(buf, off, len);
        if (this._cacheOutputStream != null) {
            this._cacheOutputStream.write(buf, off, len);
        }
    }

    @Override
    protected void write(byte b) throws IOException {
        super.write(b);
        if (this._cacheOutputStream != null) {
            this._cacheOutputStream.write(b);
        }
    }
}

