/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic.context;

import com.caucho.portal.generic.BufferFactory;
import com.caucho.portal.generic.PortletByteBuffer;
import com.caucho.portal.generic.PortletCharBuffer;
import com.caucho.portal.generic.context.AbstractResponseHandler;
import com.caucho.portal.generic.context.ResponseHandler;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class BufferedResponseHandler
extends AbstractResponseHandler {
    protected static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/context/BufferedResponseHandler").getName());
    private static final int NOT_ALLOCATED = Integer.MIN_VALUE;
    private BufferFactory _bufferFactory;
    private int _initialBufferSize = -1;
    private LinkedHashMap<String, Object> _propertiesMap;
    private int _bufferSize = Integer.MIN_VALUE;
    private PortletCharBuffer _charBuffer;
    private PortletByteBuffer _byteBuffer;
    private PrintWriter _writer;
    private OutputStream _outputStream;
    private boolean _isCommitted;

    public BufferedResponseHandler(ResponseHandler responseHandler, BufferFactory bufferFactory, int initialBufferSize) {
        this.open(responseHandler, bufferFactory, initialBufferSize);
    }

    public void open(ResponseHandler responseHandler, BufferFactory bufferFactory, int initialBufferSize) {
        super.open(responseHandler);
        this._bufferFactory = bufferFactory;
        this._initialBufferSize = initialBufferSize;
    }

    public void finish() throws IOException {
        if (!this.isError()) {
            this.flushBuffer();
        }
        this.freeBuffers(true);
        if (this._propertiesMap != null) {
            this._propertiesMap.clear();
        }
        this._isCommitted = false;
        this._writer = null;
        this._outputStream = null;
        this._bufferSize = Integer.MIN_VALUE;
        this._initialBufferSize = -1;
        this._bufferFactory = null;
        super.finish();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBufferSize(int bufferSize) {
        if (this._bufferSize == Integer.MIN_VALUE) {
            this._initialBufferSize = bufferSize;
            return;
        }
        if (bufferSize <= this._bufferSize) return;
        if (!this._isCommitted) {
            this.freeBuffers(true);
            this._initialBufferSize = bufferSize;
            return;
        }
        if (this._bufferSize != 0) throw new IllegalStateException("buffer already committed");
        if (this._initialBufferSize == 0) throw new IllegalStateException("buffer already committed");
        throw new IllegalStateException("buffer already committed to `" + this._bufferSize + "'");
    }

    public int getBufferSize() {
        if (this._bufferSize != Integer.MIN_VALUE) {
            return this._bufferSize;
        }
        if (this._initialBufferSize != -1) {
            return this._initialBufferSize;
        }
        return this._bufferFactory.getDefaultBufferSize();
    }

    public void setProperty(String name, String value) {
        if (this._isCommitted) {
            throw new IllegalStateException("response committed");
        }
        if (this._propertiesMap == null) {
            this._propertiesMap = new LinkedHashMap();
        }
        this._propertiesMap.put(name, value);
    }

    public void addProperty(String name, String value) {
        if (this._isCommitted) {
            throw new IllegalStateException("response committed");
        }
        Object existingValue = null;
        if (this._propertiesMap == null) {
            this._propertiesMap = new LinkedHashMap();
        } else {
            existingValue = this._propertiesMap.get(name);
        }
        if (existingValue == null) {
            this._propertiesMap.put(name, value);
        } else if (existingValue instanceof ArrayList) {
            ((ArrayList)existingValue).add(value);
        } else {
            ArrayList<String> valueList = new ArrayList<String>();
            valueList.add((String)existingValue);
            valueList.add(value);
        }
    }

    public boolean isCommitted() {
        return this._isCommitted;
    }

    private void allocateCharBufferIfNeeded() {
        if (this._byteBuffer != null) {
            throw new IllegalStateException("cannot allocate char buffer, byte buffer already allocated");
        }
        if (this._bufferSize == Integer.MIN_VALUE) {
            if (this._initialBufferSize != 0) {
                this._charBuffer = this._bufferFactory.allocateCharBuffer(this._initialBufferSize);
                this._bufferSize = this._charBuffer.getCapacity();
            } else {
                this._bufferSize = 0;
            }
        }
    }

    private void allocateByteBufferIfNeeded() {
        if (this._charBuffer != null) {
            throw new IllegalStateException("cannot allocate byte buffer, char buffer already allocated");
        }
        if (this._bufferSize == Integer.MIN_VALUE) {
            if (this._initialBufferSize != 0) {
                this._byteBuffer = this._bufferFactory.allocateByteBuffer(this._initialBufferSize);
                this._bufferSize = this._byteBuffer.getCapacity();
            } else {
                this._bufferSize = 0;
            }
        }
    }

    public PrintWriter getWriter() throws IOException {
        this.checkErrorOrFail();
        if (this._writer != null) {
            return this._writer;
        }
        this._writer = super.getWriter();
        return this._writer;
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkErrorOrFail();
        if (this._outputStream != null) {
            return this._outputStream;
        }
        this._outputStream = super.getOutputStream();
        return this._outputStream;
    }

    public void reset() {
        this.resetBuffer();
        if (this._propertiesMap != null) {
            this._propertiesMap.clear();
        }
    }

    public void resetBuffer() {
        if (this._isCommitted) {
            throw new IllegalStateException("response is already committed");
        }
        if (this._byteBuffer != null) {
            this._byteBuffer.reset();
        }
        if (this._charBuffer != null) {
            this._charBuffer.reset();
        }
        this.freeBuffers(true);
    }

    private void freeBuffers(boolean isAllocateAgain) {
        PortletCharBuffer charBuffer = this._charBuffer;
        PortletByteBuffer byteBuffer = this._byteBuffer;
        this._charBuffer = null;
        this._byteBuffer = null;
        if (charBuffer != null) {
            if (charBuffer.size() != 0) {
                throw new IllegalStateException("still content in buffer");
            }
            charBuffer.finish();
        }
        if (byteBuffer != null) {
            if (byteBuffer.size() != 0) {
                throw new IllegalStateException("still content in buffer");
            }
            byteBuffer.finish();
        }
        if (isAllocateAgain) {
            this._bufferSize = Integer.MIN_VALUE;
        }
    }

    public void flushBuffer() throws IOException {
        this.checkErrorOrFail();
        try {
            this.flushProperties();
            this.flushBufferOnly();
        }
        catch (Exception ex) {
            this.setError(ex);
        }
    }

    private void flushProperties() {
        if (this._propertiesMap != null && this._propertiesMap.size() > 0) {
            this._isCommitted = true;
            Iterator<Map.Entry<String, Object>> iter = this._propertiesMap.entrySet().iterator();
            do {
                Map.Entry<String, Object> entry = iter.next();
                String name = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof ArrayList) {
                    ArrayList valueList = (ArrayList)value;
                    for (int i = 0; i < valueList.size(); ++i) {
                        super.addProperty(name, (String)valueList.get(i));
                    }
                } else {
                    super.setProperty(name, (String)value);
                }
                iter.remove();
            } while (iter.hasNext());
        }
    }

    private void flushBufferOnly() throws IOException {
        if (this._charBuffer != null && this._charBuffer.size() > 0) {
            this._isCommitted = true;
            this._charBuffer.flush(super.getUnderlyingWriter());
        }
        if (this._byteBuffer != null && this._byteBuffer.size() > 0) {
            this._isCommitted = true;
            this._byteBuffer.flush(super.getUnderlyingOutputStream());
        }
        this.freeBuffers(false);
    }

    protected void print(char[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.allocateCharBufferIfNeeded();
        this.checkErrorOrFail();
        if (this._charBuffer == null) {
            this._isCommitted = true;
            super.print(buf, off, len);
        } else if (!this._charBuffer.print(buf, off, len)) {
            this.flushBuffer();
            this._isCommitted = true;
            super.print(buf, off, len);
        }
    }

    protected void print(String str, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.allocateCharBufferIfNeeded();
        this.checkErrorOrFail();
        if (this._charBuffer == null) {
            this._isCommitted = true;
            super.print(str, off, len);
        } else if (!this._charBuffer.print(str, off, len)) {
            this.flushBuffer();
            this._isCommitted = true;
            super.print(str, off, len);
        }
    }

    protected void print(char c) throws IOException {
        this.allocateCharBufferIfNeeded();
        this.checkErrorOrFail();
        if (this._charBuffer == null) {
            this._isCommitted = true;
            super.print(c);
        } else if (!this._charBuffer.print(c)) {
            this.flushBuffer();
            this._isCommitted = true;
            super.print(c);
        }
    }

    protected void write(byte[] buf, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        this.allocateByteBufferIfNeeded();
        this.checkErrorOrFail();
        if (this._byteBuffer == null) {
            this._isCommitted = true;
            super.write(buf, off, len);
        } else if (!this._byteBuffer.write(buf, off, len)) {
            this.flushBuffer();
            this._isCommitted = true;
            super.write(buf, off, len);
        }
    }

    protected void write(byte b) throws IOException {
        this.checkErrorOrFail();
        this.allocateByteBufferIfNeeded();
        if (this._byteBuffer == null) {
            this._isCommitted = true;
            super.write(b);
        } else if (!this._byteBuffer.write(b)) {
            this.flushBuffer();
            this._isCommitted = true;
            super.write(b);
        }
    }
}

