/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Action;
import com.caucho.portal.generic.Constraint;
import com.caucho.portal.generic.ConstraintFailureEvent;
import com.caucho.portal.generic.ExceptionEvent;
import com.caucho.portal.generic.GenericPortal;
import com.caucho.portal.generic.GenericPortletPreferences;
import com.caucho.portal.generic.HttpPortletConnection;
import com.caucho.portal.generic.HttpPortletContext;
import com.caucho.portal.generic.NameValuePair;
import com.caucho.portal.generic.Portal;
import com.caucho.portal.generic.Render;
import com.caucho.portal.generic.Renderer;
import com.caucho.portal.generic.ResourceBundleFactory;
import com.caucho.portal.generic.Window;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletServlet
extends HttpServlet
implements Window,
PortletConfig {
    protected static final Logger log = Logger.getLogger(ClassLiteral.getClass((String)"com/caucho/portal/generic/PortletServlet").getName());
    private Portal _portal;
    private HttpPortletContext _portletContext;
    private Portlet _portlet;
    private String _portletName;
    private String _namespace = "";
    private Map<String, String> _initParamMap;
    private int _expirationCache;
    private boolean _isPrivate;
    private Renderer _renderer;
    private int _bufferSize;
    private Set<Locale> _supportedLocales;
    private GenericPortletPreferences _defaultPreferences;
    private ResourceBundleFactory _resourceBundleFactory;

    public void setPortal(Portal portal) {
        if (this._portal != null) {
            throw new IllegalArgumentException("`portal' already set");
        }
        this._portal = portal;
    }

    public void setPortalClass(String className) {
        this.setPortal((Portal)this.newInstance(ClassLiteral.getClass((String)"com/caucho/portal/generic/Portal"), className));
    }

    public void setPortalRef(String attributeName) {
        Portal portal = (Portal)this.getServletContext().getAttribute(attributeName);
        if (portal == null) {
            throw new IllegalArgumentException(new StringBuffer().append("Portal not found with ServletContext attribute name `").append(attributeName).append("'").toString());
        }
        this.setPortal(portal);
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setPortlet(Portlet portlet) {
        if (this._portlet != null) {
            throw new IllegalArgumentException("`portlet' is already set");
        }
        this._portlet = portlet;
    }

    public void setPortletClass(String className) {
        this.setPortlet((Portlet)this.newInstance(ClassLiteral.getClass((String)"javax/portlet/Portlet"), className));
    }

    public void setPortletName(String portletName) {
        this._portletName = portletName;
    }

    public void addInitParam(String name, String value) {
        if (this._initParamMap == null) {
            this._initParamMap = new LinkedHashMap<String, String>();
        }
        this._initParamMap.put(name, value);
    }

    public void addInitParam(NameValuePair nameValuePair) {
        this.addInitParam(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void setPortletPreferences(GenericPortletPreferences defaultPreferences) {
        this._defaultPreferences = defaultPreferences;
    }

    public void setExpirationCache(int expirationCache) {
        this._expirationCache = expirationCache;
    }

    public void setPrivate(boolean isPrivate) {
        this._isPrivate = isPrivate;
    }

    void addSupportedLocale(String locale) {
        String language = "";
        String country = "";
        String variant = "";
        String[] split = locale.split("_", 3);
        int len = split.length;
        if (len == 0) {
            split = locale.split("-", 3);
            len = split.length;
        }
        if (len == 0) {
            throw new IllegalArgumentException(locale);
        }
        language = split[0];
        if (len > 0) {
            country = split[1];
        }
        if (len > 1) {
            country = split[2];
        }
        if (this._supportedLocales == null) {
            this._supportedLocales = new LinkedHashSet<Locale>();
        }
        this._supportedLocales.add(new Locale(language, country, variant));
    }

    void addSupportedLocales(String locales) {
        String[] split = locales.split("\\s*,\\s*");
        for (int i = 0; i < split.length; ++i) {
            this.addSupportedLocale(split[i]);
        }
    }

    public void setResourceBundle(String name) {
        ResourceBundleFactory resourceBundleFactory = new ResourceBundleFactory();
        resourceBundleFactory.setName(name);
        this.setResourceBundleFactory(resourceBundleFactory);
    }

    public void setResourceBundleFactory(ResourceBundleFactory factory) {
        if (this._resourceBundleFactory != null) {
            throw new IllegalArgumentException("resource-bundle-factory already set");
        }
    }

    public void setRenderer(Renderer renderer) {
        this._renderer = renderer;
    }

    public void setRendererClass(String className) {
        this.setRenderer((Renderer)this.newInstance(ClassLiteral.getClass((String)"com/caucho/portal/generic/Renderer"), className));
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String p = super.getInitParameter("portal-class");
        if (p != null) {
            this.setPortalClass(p);
        }
        if ((p = super.getInitParameter("portal-ref")) != null) {
            this.setPortalRef(p);
        }
        if (this._portal == null) {
            this._portal = new GenericPortal();
        }
        if ((p = super.getInitParameter("portlet-class")) != null) {
            this.setPortletClass(p);
        }
        if (this._portlet == null) {
            throw new ServletException("`portlet' is required");
        }
        p = super.getInitParameter("portlet-name");
        if (p != null) {
            this.setPortletName(p);
        }
        if (this._portletName == null) {
            this._portletName = servletConfig.getServletName();
        }
        if ((p = super.getInitParameter("expiration-cache")) != null) {
            this.setExpirationCache(Integer.parseInt(p));
        }
        if ((p = super.getInitParameter("private")) != null) {
            this.setPrivate(Boolean.valueOf(p));
        }
        if ((p = super.getInitParameter("buffer-size")) != null) {
            this.setBufferSize(Integer.parseInt(p));
        }
        if ((p = super.getInitParameter("supported-locales")) != null) {
            this.addSupportedLocales(p);
        }
        if ((p = super.getInitParameter("resource-bundle")) != null) {
            this.setResourceBundle(p);
        }
        if ((p = super.getInitParameter("renderer-class")) != null) {
            this.setRendererClass(p);
        }
        this._portletContext = new HttpPortletContext(this.getServletContext());
        try {
            this._portlet.init((PortletConfig)this);
        }
        catch (PortletException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected Object newInstance(Class targetClass, String className) throws IllegalArgumentException {
        Class<?> cl = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            cl = Class.forName(className, false, loader);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            throw new IllegalArgumentException(new StringBuffer().append("`").append(className).append("' is not a known class").toString());
        }
        if (!targetClass.isAssignableFrom(cl)) {
            throw new IllegalArgumentException(new StringBuffer().append("'").append(className).append("' must implement ").append(targetClass.getName()).toString());
        }
        if (Modifier.isAbstract(cl.getModifiers())) {
            throw new IllegalArgumentException(new StringBuffer().append("'").append(className).append("' must not be abstract.").toString());
        }
        if (!Modifier.isPublic(cl.getModifiers())) {
            throw new IllegalArgumentException(new StringBuffer().append("'").append(className).append("' must be public.").toString());
        }
        Constructor<?>[] constructors = cl.getDeclaredConstructors();
        Constructor<?> zeroArg = null;
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != 0) continue;
            zeroArg = constructors[i];
            break;
        }
        if (zeroArg == null || !Modifier.isPublic(zeroArg.getModifiers())) {
            throw new IllegalArgumentException(new StringBuffer().append("'").append(className).append("' must have a public zero arg constructor").toString());
        }
        Object obj = null;
        try {
            obj = cl.newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(new StringBuffer().append("error instantiating `").append(className).append("': ").append(ex.toString()).toString(), ex);
        }
        return obj;
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this;
    }

    public String getInitParameter(String name) {
        if (this._initParamMap == null) {
            return super.getInitParameter(name);
        }
        return this._initParamMap.get(name);
    }

    public Enumeration getInitParameterNames() {
        if (this._initParamMap == null) {
            return super.getInitParameterNames();
        }
        return Collections.enumeration(this._initParamMap.keySet());
    }

    @Override
    public int getExpirationCache() {
        return this._expirationCache;
    }

    @Override
    public boolean isPrivate() {
        return this._isPrivate;
    }

    @Override
    public boolean isWindowStateAllowed(PortletRequest request, WindowState windowState) {
        return true;
    }

    @Override
    public boolean isPortletModeAllowed(PortletRequest request, PortletMode portletMode) {
        return true;
    }

    @Override
    public Set<String> getSupportedContentTypes(PortletMode portletMode) {
        return null;
    }

    @Override
    public Set<Locale> getSupportedLocales() {
        return this._supportedLocales;
    }

    @Override
    public PortletPreferences getDefaultPreferences() {
        return this._defaultPreferences;
    }

    @Override
    public ArrayList<PreferencesValidator> getPreferencesValidators() {
        if (this._defaultPreferences != null) {
            return this._defaultPreferences.getPreferencesValidators();
        }
        return null;
    }

    @Override
    public Map<String, String> getRoleRefMap() {
        return null;
    }

    @Override
    public ArrayList<Constraint> getConstraints() {
        return null;
    }

    @Override
    public Renderer getRenderer() {
        return this._renderer;
    }

    @Override
    public PortletMode handlePortletModeFailure(PortletRequest request, PortletMode notAllowed) {
        return PortletMode.VIEW;
    }

    @Override
    public WindowState handleWindowStateFailure(PortletRequest request, WindowState notAllowed) {
        return WindowState.NORMAL;
    }

    @Override
    public void handleConstraintFailure(RenderRequest request, RenderResponse response, ConstraintFailureEvent event) {
    }

    @Override
    public void handleException(RenderRequest request, RenderResponse response, ExceptionEvent event) {
    }

    public String getPortletName() {
        return this._portletName;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        if (this._resourceBundleFactory == null) {
            this._resourceBundleFactory = new ResourceBundleFactory();
        }
        return this._resourceBundleFactory.getResourceBundle(locale);
    }

    @Override
    public int getBufferSize() {
        return this._bufferSize;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doRequest(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        HttpPortletConnection connection = new HttpPortletConnection();
        connection.start(this._portal, (PortletContext)this._portletContext, httpRequest, httpResponse, true);
        try {
            Render render;
            Action action = connection.getAction(this, this._namespace);
            if (action != null) {
                try {
                    if (action.isTarget()) {
                        action.processAction(this._portlet);
                    }
                }
                finally {
                    action.finish();
                }
            }
            if ((render = connection.getRender(this, this._namespace)) != null) {
                try {
                    render.render(this._portlet);
                }
                finally {
                    render.finish();
                }
            }
            connection.checkForFailure();
        }
        catch (PortletException ex) {
            throw new ServletException((Throwable)ex);
        }
        finally {
            connection.finish();
        }
    }

    public void destroy() {
        if (this._portlet != null) {
            this._portlet.destroy();
        }
    }
}

