/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.Invocation;
import com.caucho.portal.generic.InvocationFactory;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletSecurityException;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InvocationURL {
    private InvocationFactory _invocationFactory;
    private String _namespace;
    private Invocation _invocation;
    private Boolean _isSecure;

    public abstract String getURL();

    public InvocationURL(InvocationFactory invocationFactory, String namespace) {
        this._invocationFactory = invocationFactory;
        this._namespace = namespace;
    }

    public String getNamespace() {
        return this._namespace;
    }

    protected Invocation getInvocation() {
        if (this._invocation == null) {
            this._invocation = this._invocationFactory.getInvocation(this._namespace);
        }
        return this._invocation;
    }

    protected Invocation getInvocation(String namespace) {
        return this._invocationFactory.getInvocation(namespace);
    }

    protected void setWindowState(Invocation invocation, WindowState windowState) throws WindowStateException {
        invocation.setWindowState(windowState);
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        this.setWindowState(this.getInvocation(), windowState);
    }

    public void setWindowState(String namespace, WindowState windowState) throws WindowStateException {
        this.setWindowState(this.getInvocation(namespace), windowState);
    }

    protected void setPortletMode(Invocation invocation, PortletMode portletMode) throws PortletModeException {
        invocation.setPortletMode(portletMode);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        this.setPortletMode(this.getInvocation(), portletMode);
    }

    public void setPortletMode(String namespace, PortletMode portletMode) throws PortletModeException {
        this.setPortletMode(this.getInvocation(namespace), portletMode);
    }

    protected Map<String, String[]> getRenderParameterMap() {
        return this.getInvocation().getParameterMap();
    }

    protected Map<String, String[]> getRenderParameterMap(String namespace) {
        return this.getInvocation(namespace).getParameterMap();
    }

    private void checkNullName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("parameter name cannot be null");
        }
    }

    private void checkNullValue(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("parameter value cannot be null");
        }
    }

    protected String getParameterValue(Map<String, String[]> map, String name) {
        this.checkNullName(name);
        String[] values = map.get(name);
        return values == null || values.length == 0 ? null : values[0];
    }

    protected String[] getParameterValues(Map<String, String[]> map, String name) {
        this.checkNullName(name);
        return map.get(name);
    }

    protected Enumeration getParameterNames(Map<String, String[]> map) {
        return Collections.enumeration(map.keySet());
    }

    protected void setParameter(Map<String, String[]> map, String name, String value) {
        this.checkNullName(name);
        this.checkNullValue(value);
        map.put(name, new String[]{value});
    }

    protected void setParameters(Map<String, String[]> destMap, Map<String, String[]> srcMap) {
        this.checkNullValue(srcMap);
        destMap.clear();
        for (Map.Entry<String, String[]> entry : srcMap.entrySet()) {
            this.setParameter(destMap, entry.getKey(), entry.getValue());
        }
    }

    protected void setParameter(Map<String, String[]> map, String name, String[] values) {
        this.checkNullName(name);
        this.checkNullValue(values);
        if (values.length == 0) {
            map.remove(name);
        } else {
            map.put(name, values);
        }
    }

    public void setParameter(String name, String value) {
        this.setParameter(this.getRenderParameterMap(), name, value);
    }

    public void setParameter(String name, String[] values) {
        this.setParameter(this.getRenderParameterMap(), name, values);
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.setParameters(this.getRenderParameterMap(), parameters);
    }

    public void setParameter(String namespace, String name, String value) {
        this.setParameter(this.getRenderParameterMap(namespace), name, value);
    }

    public void setParameter(String namespace, String name, String[] values) {
        this.setParameter(this.getRenderParameterMap(namespace), name, values);
    }

    public void setParameters(String namespace, Map<String, String[]> parameters) {
        this.setParameters(this.getRenderParameterMap(namespace), parameters);
    }

    public void setSecure(boolean secure) throws PortletSecurityException {
        this._isSecure = secure ? Boolean.TRUE : Boolean.FALSE;
    }

    protected boolean isSecureSpecified() {
        return this._isSecure != null;
    }

    protected boolean isSecure() {
        return this._isSecure == null || this._isSecure == Boolean.FALSE;
    }
}

