/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.portal.generic;

import com.caucho.portal.generic.KeyLinkMap;
import com.caucho.portal.generic.NameLink;
import com.caucho.portal.generic.NameValuePair;
import com.caucho.portal.generic.PreferencesStore;
import com.caucho.portal.generic.StoreUpdateMap;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.portlet.PortletRequest;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreferencesStore
implements PreferencesStore {
    protected static String[] DELETE = new String[]{"<delete>"};
    private LinkedHashMap<String, String[]> _defaultMap;
    private HashMap<String, String> _nameLinkMap;
    private Map<String, String> _reverseNameLinkMap;

    protected abstract Map<String, String[]> load(PortletRequest var1, String var2) throws IOException;

    protected abstract void save(Map<String, String[]> var1, Map<String, String[]> var2) throws IOException;

    protected abstract void unload(Map<String, String[]> var1);

    public void addDefault(String name, String value) {
        String[] values;
        if (this._defaultMap == null) {
            this._defaultMap = new LinkedHashMap();
        }
        if ((values = this._defaultMap.get(name)) == null) {
            values = new String[]{value};
        } else {
            String[] newValues = new String[values.length + 1];
            for (int i = 0; i < values.length; ++i) {
                newValues[i] = values[i];
            }
            newValues[i] = value;
        }
        this._defaultMap.put(name, values);
    }

    public void addDefault(NameValuePair nameValuePair) {
        this.addDefault(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void addNameLink(String name, String link) {
        if (this._nameLinkMap == null) {
            this._nameLinkMap = new HashMap();
        }
        this._nameLinkMap.put(name, link);
    }

    public void addNameLink(NameLink nameLink) {
        this.addNameLink(nameLink.getName(), nameLink.getLink());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String[]> getPreferencesMap(PortletRequest request, String namespace) throws IOException {
        Map<String, String[]> storeMap = this.load(request, namespace);
        StoreUpdateMap<String, String[]> map = new StoreUpdateMap<String, String[]>();
        if (this._nameLinkMap != null) {
            HashMap<String, String> hashMap = this._nameLinkMap;
            synchronized (hashMap) {
                if (this._reverseNameLinkMap == null) {
                    this._reverseNameLinkMap = KeyLinkMap.getReverseKeyLinkMap(this._nameLinkMap);
                }
            }
        }
        map.start(this._nameLinkMap, this._reverseNameLinkMap, this._defaultMap, storeMap, null, DELETE);
        return map;
    }

    @Override
    public void finish(Map<String, String[]> preferencesMap) throws IOException {
        StoreUpdateMap map = (StoreUpdateMap)preferencesMap;
        Map<String, String[]> storeMap = map.getStoreMap();
        Map<String, String[]> updateMap = map.getUpdateMap();
        map.finish();
        if (updateMap != null) {
            this.save(storeMap, updateMap);
        }
        this.unload(storeMap);
    }
}

