/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.naming;

import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;

public class PathJndiContext
implements Context {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/naming/PathJndiContext"));
    private PathJndiContext _root;
    private Path _path;

    public PathJndiContext(Path path) {
        this._root = this;
        this._path = path;
    }

    PathJndiContext(Path path, PathJndiContext root) {
        this._root = root;
        this._path = path;
        if (root == null) {
            this._root = root;
        }
    }

    public Path getPath() {
        return this._path;
    }

    public Object lookup(String name) throws NamingException {
        if (name == null || name.equals("")) {
            return new PathJndiContext(this._path.lookup(null), this._root);
        }
        Path subpath = this._path.lookup(name);
        if (subpath == null) {
            throw new NamingException(L.l("bad path {0}", name));
        }
        if (subpath.isDirectory()) {
            return new PathJndiContext(subpath, this._root);
        }
        if (subpath.isObject()) {
            try {
                return subpath.getValue();
            }
            catch (Exception e) {
                throw new NamingException(e.toString());
            }
        }
        if (!subpath.exists()) {
            return null;
        }
        throw new NamingException(L.l("lookup can't handle files"));
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void bind(String name, Object obj) throws NamingException {
        Path subpath = this._path.lookup(name);
        Path parent = subpath.getParent();
        if (!parent.exists()) {
            try {
                parent.mkdirs();
            }
            catch (IOException e) {
                throw new NamingException(e.toString());
            }
        }
        if (!parent.isDirectory()) {
            throw new NamingException(L.l("bind expects directory for `{0}'", subpath.getParent()));
        }
        if (subpath.exists()) {
            throw new NameAlreadyBoundException(L.l("`{0}' already has a binding", subpath));
        }
        try {
            subpath.setValue(obj);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        Path subpath = this._path.lookup(name);
        try {
            Path parent = subpath.getParent();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            subpath.setValue(obj);
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void unbind(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        try {
            subpath.remove();
        }
        catch (IOException e) {
            throw new NamingException(L.l("can't remove `{0}'"));
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return null;
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        if (!subpath.exists()) {
            throw new NameNotFoundException(name);
        }
        if (!subpath.isDirectory()) {
            throw new NotContextException(name);
        }
        try {
            subpath.remove();
        }
        catch (IOException e) {
            throw new ContextNotEmptyException(name);
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        Path subpath = this._path.lookup(name);
        if (!subpath.getParent().isDirectory()) {
            throw new NamingException(L.l("parent of `{0}' must be directory", name));
        }
        try {
            subpath.mkdir();
        }
        catch (IOException e) {
            throw new ContextNotEmptyException(name);
        }
        return new PathJndiContext(subpath, this._root);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        throw new NamingException(L.l("links not supported"));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String name) throws NamingException {
        return new PathNameParser();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    public String composeName(String prefix, String suffix) throws NamingException {
        return prefix + "/" + suffix;
    }

    public Name composeName(Name prefix, Name suffix) throws NamingException {
        return null;
    }

    public String getNameInNamespace() throws NamingException {
        return this._path.getPath();
    }

    public Object addToEnvironment(String prop, Object value) throws NamingException {
        try {
            Object old = this._path.getAttribute(prop);
            this._path.setAttribute(prop, value);
            return old;
        }
        catch (IOException e) {
            throw new NamingException(e.toString());
        }
    }

    public Object removeFromEnvironment(String prop) throws NamingException {
        try {
            Object old = this._path.getAttribute(prop);
            this._path.removeAttribute(prop);
            return old;
        }
        catch (IOException e) {
            throw new NamingException(e.toString());
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        return null;
    }

    public void close() throws NamingException {
    }

    static class PathNameParser
    implements NameParser {
        PathNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompositeName(name);
        }
    }
}

