/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make.task;

import com.caucho.java.JavaCompiler;
import com.caucho.log.Log;
import com.caucho.make.Make;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;

public class JavacTask
implements Make {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/make/task/JavacTask"));
    private Path _srcdir;
    private Path _dstdir;

    public void setSrcdir(Path path) {
        this._srcdir = path;
    }

    public void setDstdir(Path path) {
        this._dstdir = path;
    }

    public void make() throws Exception {
        Path srcDir;
        Path dstDir = this._dstdir;
        if (dstDir == null) {
            dstDir = Vfs.lookup("WEB-INF/classes");
        }
        if ((srcDir = this._srcdir) == null) {
            srcDir = dstDir;
        }
        JavaCompiler compiler = JavaCompiler.create();
        compiler.setClassDir(dstDir);
        this.makeAll(compiler, srcDir, dstDir);
    }

    public void makeAll(JavaCompiler compiler, Path srcDir, Path dstDir) throws Exception {
        String[] list = srcDir.list();
        for (int i = 0; i < list.length; ++i) {
            Path subSrc = srcDir.lookup(list[i]);
            if (subSrc.isDirectory()) {
                this.makeAll(compiler, subSrc, dstDir.lookup(list[i]));
                continue;
            }
            if (!list[i].endsWith(".java")) continue;
            this.makeJava(compiler, subSrc, dstDir);
        }
    }

    public void makeJava(JavaCompiler compiler, Path javaSrc, Path dstDir) throws Exception {
        String tail = javaSrc.getTail();
        Path classFile = dstDir.lookup(tail.substring(0, tail.length() - 5) + ".class");
        if (javaSrc.getLastModified() <= classFile.getLastModified()) {
            return;
        }
        compiler.compileIfModified(javaSrc.getPath(), null);
    }
}

