/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make.task;

import com.caucho.doclet.DocletCompiler;
import com.caucho.doclet.RootDocImpl;
import com.caucho.log.Log;
import com.caucho.make.Make;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocletTask
implements Make {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/make/task/DocletTask"));
    private Path _srcdir;
    private Path _dstdir;
    private boolean _isComplete;

    public void setSrcdir(Path path) {
        this._srcdir = path;
    }

    public void setDstdir(Path path) {
        this._dstdir = path;
    }

    @Override
    public void make() throws Exception {
        Path srcDir;
        Path dstDir = this._dstdir;
        if (dstDir == null) {
            dstDir = Vfs.lookup("WEB-INF/classes");
        }
        if ((srcDir = this._srcdir) == null) {
            srcDir = dstDir;
        }
        ArrayList<String> paths = new ArrayList<String>();
        this.gatherPaths(paths, srcDir);
        DocletCompiler doclet = new DocletCompiler();
        if (!this._isComplete) {
            this._isComplete = true;
            RootDocImpl rootDoc = doclet.run(srcDir, paths);
        }
    }

    public void gatherPaths(ArrayList<String> paths, Path srcDir) throws Exception {
        String[] list = srcDir.list();
        for (int i = 0; i < list.length; ++i) {
            Path subSrc = srcDir.lookup(list[i]);
            if (subSrc.isDirectory()) {
                this.gatherPaths(paths, subSrc);
                continue;
            }
            if (!list[i].endsWith("Bean.java")) continue;
            paths.add(subSrc.getNativePath());
        }
    }
}

