/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.config.DynamicBean;
import com.caucho.config.DynamicItem;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.loader.Loader;
import com.caucho.log.Log;
import com.caucho.make.Dependency;
import com.caucho.make.Make;
import com.caucho.make.TaskConfig;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MakeLoader
extends Loader
implements DynamicBean,
Make {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/make/MakeLoader"));
    private static final EnvironmentLocal<DynamicItem[]> _localConfig = new EnvironmentLocal();
    private static DynamicItem[] _configItems;
    private Path _path;
    private ArrayList<Dependency> _dependList = new ArrayList();
    private ArrayList<Make> _makeList = new ArrayList();

    public DynamicItem[] getDynamicConfigurationElements() {
        DynamicItem[] configItems = _localConfig.get();
        if (configItems == null) {
            ArrayList<DynamicItem> items = new ArrayList<DynamicItem>();
            items.add(new DynamicItem("javac", ClassLiteral.getClass((String)"com/caucho/make/task/JavacTask"), "make"));
            items.add(new DynamicItem("doclet", ClassLiteral.getClass((String)"com/caucho/make/task/DocletTask"), "make"));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                Class<?> taskClass = Class.forName("com.caucho.ejb.doclet.EjbDocletTask", false, loader);
                items.add(new DynamicItem("ejb-doclet", taskClass, "make"));
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            configItems = items.toArray(new DynamicItem[items.size()]);
            _localConfig.set(configItems);
        }
        return configItems;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public Path getPath() {
        return this._path;
    }

    public void setLoader(DynamicClassLoader loader) {
        super.setLoader(loader);
        loader.addURL(this._path);
    }

    public Path getPath(String name) {
        for (int i = 0; i < this._makeList.size(); ++i) {
            Make make = this._makeList.get(i);
            try {
                make.make();
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this._path.lookup(name);
    }

    public void addTask(TaskConfig task) {
        Object obj = task.getTask();
        if (obj instanceof Make) {
            this._makeList.add((Make)obj);
        }
    }

    public void addMake(Make make) {
        this._makeList.add(make);
    }

    public void make() throws Exception {
    }

    protected String getClassPath(String head) {
        CharBuffer cb = new CharBuffer();
        if (!head.equals("")) {
            cb.append(head);
            cb.append(CauchoSystem.getPathSeparatorChar());
        }
        if (this._path instanceof JarPath) {
            cb.append(((JarPath)this._path).getContainer().getNativePath());
        } else if (this._path.isDirectory()) {
            cb.append(this._path.getNativePath());
        }
        return cb.toString();
    }

    public String toString() {
        return "MakeLoader[" + this._path + "]";
    }
}

