/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.make;

import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassDependency
implements PersistentDependency {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/make/ClassDependency"));
    private Class _cl;
    private boolean _checkFields = true;
    private boolean _checkStatic = true;
    private boolean _checkProtected = true;
    private boolean _checkPrivate = true;
    private boolean _isDigestModified;

    public ClassDependency(Class cl) {
        this._cl = cl;
    }

    public ClassDependency(Class cl, String digest) {
        this._cl = cl;
        String newDigest = this.getDigest();
        if (!newDigest.equals(digest)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this._cl.getName() + " digest is modified.");
            }
            this._isDigestModified = true;
        }
    }

    public boolean isModified() {
        return this._isDigestModified;
    }

    public String getDigest() {
        try {
            if (this._cl == null) {
                return "";
            }
            MessageDigest digest = MessageDigest.getInstance("MD5");
            ClassDependency.addDigest(digest, this._cl.getName());
            ClassDependency.addDigest(digest, this._cl.getModifiers());
            Class cl = this._cl.getSuperclass();
            if (cl != null) {
                ClassDependency.addDigest(digest, cl.getName());
            }
            Class<?>[] interfaces = this._cl.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                ClassDependency.addDigest(digest, interfaces[i].getName());
            }
            Field[] fields = this._cl.getFields();
            Arrays.sort(fields, new FieldComparator());
            if (this._checkFields) {
                for (int i = 0; i < fields.length; ++i) {
                    if (Modifier.isPrivate(fields[i].getModifiers()) && !this._checkPrivate || Modifier.isProtected(fields[i].getModifiers()) && !this._checkProtected) continue;
                    ClassDependency.addDigest(digest, fields[i].getName());
                    ClassDependency.addDigest(digest, fields[i].getModifiers());
                    ClassDependency.addDigest(digest, fields[i].getType().getName());
                }
            }
            Method[] methods = this._cl.getMethods();
            Arrays.sort(methods, new MethodComparator());
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (Modifier.isPrivate(method.getModifiers()) && !this._checkPrivate || Modifier.isProtected(method.getModifiers()) && !this._checkProtected || Modifier.isStatic(method.getModifiers()) && !this._checkStatic) continue;
                ClassDependency.addDigest(digest, method.getName());
                ClassDependency.addDigest(digest, method.getModifiers());
                ClassDependency.addDigest(digest, method.getName());
                Class<?>[] param = method.getParameterTypes();
                for (int j = 0; j < param.length; ++j) {
                    ClassDependency.addDigest(digest, param[j].getName());
                }
                ClassDependency.addDigest(digest, method.getReturnType().getName());
                Class<?>[] exn = method.getExceptionTypes();
                for (int j = 0; j < exn.length; ++j) {
                    ClassDependency.addDigest(digest, exn[j].getName());
                }
            }
            byte[] digestBytes = new byte[256];
            int len = digest.digest(digestBytes, 0, digestBytes.length);
            return this.digestToBase64(digestBytes, len);
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
            return "";
        }
    }

    public String getJavaCreateString() {
        return "new com.caucho.make.ClassDependency(" + this._cl.getName() + ".class, \"" + this.getDigest() + "\")";
    }

    private static void addDigest(MessageDigest digest, int v) {
        digest.update((byte)(v >> 24));
        digest.update((byte)(v >> 16));
        digest.update((byte)(v >> 8));
        digest.update((byte)v);
    }

    private static void addDigest(MessageDigest digest, String string) {
        if (string == null) {
            return;
        }
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                digest.update((byte)ch);
                continue;
            }
            if (ch < '\u0800') {
                digest.update((byte)(192 + (ch >> 6)));
                digest.update((byte)(128 + (ch & 0x3F)));
                continue;
            }
            digest.update((byte)(224 + (ch >> 12)));
            digest.update((byte)(128 + (ch >> 6 & 0x3F)));
            digest.update((byte)(128 + (ch & 0x3F)));
        }
    }

    private String digestToBase64(byte[] digest, int len) {
        CharBuffer cb = CharBuffer.allocate();
        Base64.encode(cb, digest, 0, len);
        return cb.close();
    }

    public boolean isEqual(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassDependency)) {
            return false;
        }
        ClassDependency depend = (ClassDependency)o;
        return this._cl.equals(depend._cl);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MethodComparator
    implements Comparator<Method> {
        MethodComparator() {
        }

        @Override
        public int compare(Method a, Method b) {
            Class<?>[] paramB;
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            Class<?>[] paramA = a.getParameterTypes();
            if (paramA.length < (paramB = b.getParameterTypes()).length) {
                return -1;
            }
            if (paramB.length < paramA.length) {
                return 1;
            }
            for (int i = 0; i < paramA.length; ++i) {
                cmp = paramA[i].getName().compareTo(paramB[i].getName());
                if (cmp == 0) continue;
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FieldComparator
    implements Comparator<Field> {
        FieldComparator() {
        }

        @Override
        public int compare(Field a, Field b) {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.equals(b)) {
                return 0;
            }
            int cmp = a.getName().compareTo(b.getName());
            if (cmp != 0) {
                return cmp;
            }
            cmp = a.getDeclaringClass().getName().compareTo(b.getDeclaringClass().getName());
            if (cmp != 0) {
                return cmp;
            }
            return a.getType().getName().compareTo(b.getType().getName());
        }
    }
}

