/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Bytes;
import com.caucho.config.types.Period;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.RotateStream;
import com.rc.retroweaver.runtime.ClassLiteral;

public class RotateLog {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/log/RotateLog"));
    private static final long ROLLOVER_SIZE = 0x6400000L;
    private Path _path;
    private RotateStream _rotateStream;
    private long _rolloverPeriod = -1L;
    private long _rolloverSize = 0x6400000L;
    private int _rolloverCount = 10;
    private String _timestamp;
    private String _archiveFormat;

    public Path getPath() {
        return this._path;
    }

    public void setPath(Path path) {
        this._path = path;
    }

    public void setHref(Path path) {
        this.setPath(path);
    }

    public long getRolloverPeriod() {
        return this._rolloverPeriod;
    }

    public void setRolloverPeriod(Period period) {
        this._rolloverPeriod = period.getPeriod();
    }

    public long getRolloverSize() {
        return this._rolloverSize;
    }

    public void setRolloverSize(Bytes bytes) {
        this._rolloverSize = bytes.getBytes();
    }

    public int getRolloverCount() {
        return this._rolloverCount;
    }

    public void setRolloverCount(int count) {
        this._rolloverCount = count;
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public String getArchiveFormat() {
        return this._archiveFormat;
    }

    public void setArchiveFormat(String format) {
        this._archiveFormat = format;
    }

    public RotateStream getRotateStream() {
        return this._rotateStream;
    }

    public String getTagName() {
        return "rotate-log";
    }

    public void init() throws ConfigException {
        if (this._path == null) {
            throw new ConfigException(L.l("`path' is a required attribute of <{0}>.  Each <{0}> must configure the destination stream.", this.getTagName()));
        }
        this._rotateStream = RotateStream.create(this._path);
        this._rotateStream.setRolloverPeriod(this._rolloverPeriod);
        this._rotateStream.setRolloverSize(this._rolloverSize);
        this._rotateStream.setMaxRolloverCount(this._rolloverCount);
        if (this._archiveFormat != null) {
            this._rotateStream.setArchiveFormat(this._archiveFormat);
        }
        this._rotateStream.init();
    }
}

