/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.log;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.log.ELFormatter;
import com.caucho.log.RotateLog;
import com.caucho.log.StreamHandler;
import com.caucho.util.L10N;
import com.caucho.vfs.TimestampFilter;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogConfig
extends RotateLog {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/log/LogConfig"));
    private ArrayList<Handler> _handlers;
    private Handler _handler;
    private Formatter _formatter;
    private String _timestamp;
    private ArrayList<SubLogger> _subLoggers = new ArrayList();
    private SubLogger _subLogger;

    public LogConfig() {
        this.setTimestamp("[%Y/%m/%d %H:%M:%S.%s] ");
    }

    public void setId(String name) {
        if (name.equals("/")) {
            name = "";
        }
        this.setName(name);
    }

    public void setName(String name) {
        this.getSubLogger().setName(name);
    }

    public void setUseParentHandlers(boolean useParentHandlers) throws ConfigException {
        this.getSubLogger().setUseParentHandlers(useParentHandlers);
    }

    public void setLevel(String level) throws ConfigException {
        this.getSubLogger().setLevel(level);
    }

    private SubLogger getSubLogger() {
        if (this._subLogger == null) {
            this._subLogger = new SubLogger();
            this._subLoggers.add(this._subLogger);
        }
        return this._subLogger;
    }

    public void setTimestamp(String timestamp) {
        this._timestamp = timestamp;
    }

    public void setFormat(RawString format) {
        if (this._formatter == null) {
            this._formatter = new ELFormatter();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).setFormat(format);
        }
    }

    public String getFormat() {
        if (this._formatter != null && this._formatter instanceof ELFormatter) {
            return ((ELFormatter)this._formatter).getFormat();
        }
        return null;
    }

    public void setFormatter(Formatter formatter) {
        this._formatter = formatter;
    }

    public void addHandler(Handler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        if (this._handlers == null) {
            this._handlers = new ArrayList();
        }
        this._handlers.add(handler);
    }

    public String getTagName() {
        return "log";
    }

    public SubLogger createLogger() {
        SubLogger subLogger = new SubLogger();
        this._subLoggers.add(subLogger);
        return subLogger;
    }

    public void init() throws ConfigException {
        if (this._handlers == null) {
            super.init();
        }
        if (this._subLoggers.size() == 0) {
            this.getSubLogger();
        }
        if (this._subLogger != null) {
            this._subLogger.init();
        }
        if (this._formatter instanceof ELFormatter) {
            ((ELFormatter)this._formatter).init();
        }
        WriteStream os = null;
        if (this._handler == null && this._handlers == null) {
            os = this.getRotateStream().getStream();
            if (this._timestamp != null) {
                TimestampFilter filter = new TimestampFilter();
                filter.setTimestamp(this._timestamp);
                filter.setStream(os);
                os = new WriteStream(filter);
            }
            os.setDisableClose(true);
        }
        for (int i = 0; i < this._subLoggers.size(); ++i) {
            SubLogger subLogger = this._subLoggers.get(i);
            Logger logger = subLogger.getLogger();
            if (this._handlers != null) {
                for (int j = 0; j < this._handlers.size(); ++j) {
                    logger.addHandler(this._handlers.get(j));
                }
                continue;
            }
            StreamHandler handler = new StreamHandler(os);
            handler.setLevel(subLogger.getLevel());
            handler.setFormatter(this._formatter);
            logger.addHandler(handler);
        }
    }

    public static class SubLogger {
        private Logger _logger;
        private String _name = "";
        private Level _level = Level.INFO;
        private boolean _useParentHandlers = true;

        public void setId(String name) {
            if (name.equals("/")) {
                name = "";
            }
            this.setName(name);
        }

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setUseParentHandlers(boolean useParentHandlers) throws ConfigException {
            this._logger = Logger.getLogger(this._name);
            this._logger.setUseParentHandlers(useParentHandlers);
        }

        public Logger getLogger() {
            return Logger.getLogger(this._name);
        }

        public Level getLevel() {
            return this._level;
        }

        public void setLevel(String level) throws ConfigException {
            if (level.equals("off")) {
                this._level = Level.OFF;
            } else if (level.equals("severe")) {
                this._level = Level.SEVERE;
            } else if (level.equals("warning")) {
                this._level = Level.WARNING;
            } else if (level.equals("info")) {
                this._level = Level.INFO;
            } else if (level.equals("config")) {
                this._level = Level.CONFIG;
            } else if (level.equals("fine")) {
                this._level = Level.FINE;
            } else if (level.equals("finer")) {
                this._level = Level.FINER;
            } else if (level.equals("finest")) {
                this._level = Level.FINEST;
            } else if (level.equals("all")) {
                this._level = Level.ALL;
            } else {
                throw new ConfigException(L.l("`{0}' is an unknown log level.  Log levels are:\noff - disable logging\nsevere - severe errors only\nwarning - warnings\ninfo - information\nconfig - configuration\nfine - fine debugging\nfiner - finer debugging\nfinest - finest debugging\nall - all debugging", level));
            }
        }

        public void init() throws ConfigException {
            if (this._name == null) {
                throw new ConfigException(L.l("`name' is a required attribute..  Each logger must configure the log name, e.g. com.caucho.server.webapp."));
            }
        }
    }
}

