/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.loader;

import com.caucho.config.ConfigException;
import com.caucho.loader.CompilingLoader;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.LibraryLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.TreeLoader;
import com.caucho.loader.enhancer.Enhancer;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.make.MakeLoader;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;

public class ClassLoaderConfig {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/loader/ClassLoaderConfig"));
    private EnvironmentClassLoader _classLoader;
    private EnvironmentBean _owner;
    private EnhancingClassLoader _enhancingClassLoader;
    private Path _source;
    private boolean _servletHack;
    private int _index;

    public ClassLoaderConfig() throws ConfigException {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (!(loader instanceof EnvironmentClassLoader)) {
            throw new ConfigException(L.l("<class-loader> requires an EnvironmentClassLoader."));
        }
        this._classLoader = (EnvironmentClassLoader)loader;
        this._owner = this._classLoader.getOwner();
        if (this._owner == null) {
            throw new ConfigException(L.l("<class-loader> requires an environment with an EnvironmentBean owner."));
        }
    }

    public void setServletHack(boolean hack) {
        this._classLoader.setServletHack(hack);
    }

    public void addSimpleLoader(SimpleLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addLibraryLoader(LibraryLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addCompilingLoader(CompilingLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addTreeLoader(TreeLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addMakeLoader(MakeLoader loader) {
        this._classLoader.addLoader(loader, this._index++);
    }

    public void addEnhancer(Enhancer enhancer) throws ConfigException {
        if (this._enhancingClassLoader == null) {
            if (this._classLoader instanceof EnhancingClassLoader) {
                this._enhancingClassLoader = (EnhancingClassLoader)this._classLoader;
            } else {
                throw new ConfigException(L.l("class-loader enhancement is not possible in this context '{0}'", this._classLoader));
            }
        }
        this._enhancingClassLoader.addEnhancer(enhancer);
    }

    public void init() throws ConfigException {
        this._classLoader.init();
        this._classLoader.validate();
        if (this._enhancingClassLoader != null) {
            this._enhancingClassLoader.init();
            this._enhancingClassLoader.validate();
        }
    }

    public String toString() {
        return "ClassLoaderConfig[]";
    }
}

