/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.lifecycle;

import com.caucho.lifecycle.LifecycleState;
import com.caucho.util.Alarm;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Lifecycle
implements LifecycleState {
    private final Logger _log;
    private String _name;
    private Level _level = Level.FINE;
    private int _state;

    public Lifecycle() {
        this._log = null;
    }

    public Lifecycle(Logger log) {
        this._log = log;
    }

    public Lifecycle(Logger log, String name) {
        this._log = log;
        this._name = name;
    }

    public Lifecycle(Logger log, String name, Level level) {
        this._log = log;
        this._name = name;
        this._level = level;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public Level getLevel() {
        return this._level;
    }

    public void setLevel(Level level) {
        this._level = level;
    }

    public int getState() {
        return this._state;
    }

    public String getStateName() {
        switch (this._state) {
            case 0: {
                return "new";
            }
            case 1: {
                return "initializing";
            }
            case 2: {
                return "init";
            }
            case 3: {
                return "starting";
            }
            case 5: {
                return "failed";
            }
            case 4: {
                return "active";
            }
            case 6: {
                return "stopping";
            }
            case 7: {
                return "stopped";
            }
            case 8: {
                return "destroying";
            }
            case 9: {
                return "destroyed";
            }
        }
        return "unknown";
    }

    public boolean isInitializing() {
        return this._state == 1;
    }

    public boolean isInit() {
        return this._state == 2;
    }

    public boolean isBeforeInit() {
        return this._state < 2;
    }

    public boolean isAfterInit() {
        return this._state >= 2;
    }

    public boolean isStarting() {
        return this._state == 3;
    }

    public boolean isBeforeActive() {
        return this._state < 4;
    }

    public boolean isAfterActive() {
        return 4 < this._state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForActive(long timeout) {
        if (this._state == 4) {
            return true;
        }
        long waitEnd = Alarm.getCurrentTime() + timeout;
        Lifecycle lifecycle = this;
        synchronized (lifecycle) {
            while (Alarm.getCurrentTime() < waitEnd) {
                if (this._state == 4) {
                    return true;
                }
                if (4 < this._state) {
                    return false;
                }
                if (Alarm.isTest()) {
                    return false;
                }
                try {
                    this.wait(waitEnd - Alarm.getCurrentTime());
                }
                catch (InterruptedException e) {}
            }
        }
        return this._state == 4;
    }

    public boolean isActive() {
        return this._state == 4;
    }

    public boolean isFailed() {
        return this._state == 5;
    }

    public boolean isStopped() {
        return 6 <= this._state;
    }

    public boolean isDestroyed() {
        return 9 <= this._state;
    }

    public synchronized boolean toInitializing() {
        if (1 <= this._state) {
            return false;
        }
        this._state = 1;
        if (this._log != null && this._log.isLoggable(Level.FINE)) {
            this._log.fine(this._name + " initializing");
        }
        return true;
    }

    public synchronized boolean toInit() {
        if (2 <= this._state) {
            return false;
        }
        this._state = 2;
        if (this._log != null && this._log.isLoggable(Level.FINE)) {
            this._log.fine(this._name + " initialized");
        }
        return true;
    }

    public synchronized boolean toStarting() {
        if (this._state < 3 || this._state == 7) {
            this._state = 3;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " starting");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean toActive() {
        if (this._state < 4 || this._state == 7) {
            this._state = 4;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(this._name + " active");
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toFailed() {
        if (this._state != 9 && this._state != 5) {
            this._state = 5;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " failed");
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toStopping() {
        if (this._state < 6 && this._state != 3) {
            this._state = 6;
            if (this._log != null && this._log.isLoggable(this._level)) {
                this._log.log(this._level, this._name + " stopping");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean toStop() {
        if (this._state < 7) {
            if (this._log != null) {
                if (this._state < 6 && this._log.isLoggable(this._level)) {
                    this._log.log(this._level, this._name + " stopped");
                } else if (this._log.isLoggable(Level.FINE)) {
                    this._log.fine(this._name + " stopped");
                }
            }
            this._state = 7;
            this.notifyAll();
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroying() {
        if (this._state < 8) {
            this._state = 8;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(this._name + " destroying");
            }
            return true;
        }
        return false;
    }

    public synchronized boolean toDestroy() {
        if (this._state < 9) {
            this._state = 9;
            if (this._log != null && this._log.isLoggable(Level.FINE)) {
                this._log.fine(this._name + " destroyed");
            }
            this.notifyAll();
            return true;
        }
        return false;
    }

    public void copyState(Lifecycle source) {
        this._state = source._state;
    }

    public String toString() {
        if (this._name != null) {
            return "Lifecycle[" + this._name + ", " + this.getStateName() + "]";
        }
        return "Lifecycle[" + this.getStateName() + "]";
    }
}

