/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.rt;

import com.caucho.jsp.BodyContentImpl;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.rt.CoreSetTag;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FormatNumberTag
extends BodyTagSupport {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/rt/FormatNumberTag"));
    private double _value;
    private boolean _hasValue;
    private String _type;
    private String _pattern;
    private String _currencyCode;
    private String _currencySymbol;
    private boolean _groupingUsed = true;
    private int _maxIntegerDigits = -1;
    private int _minIntegerDigits = -1;
    private int _maxFractionDigits = -1;
    private int _minFractionDigits = -1;
    private String _var;
    private String _scope;

    public void setValue(double value) {
        this._value = value;
        this._hasValue = true;
    }

    public void setType(String type) {
        this._type = type;
    }

    public void setPattern(String pattern) {
        this._pattern = pattern;
    }

    public void setCurrencyCode(String currency) {
        this._currencyCode = currency;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this._currencySymbol = currencySymbol;
    }

    public void setGroupingUsed(boolean groupingUsed) {
        this._groupingUsed = groupingUsed;
    }

    public void setMinIntegerDigits(int minIntegerDigits) {
        this._minIntegerDigits = minIntegerDigits;
    }

    public void setMaxIntegerDigits(int maxIntegerDigits) {
        this._maxIntegerDigits = maxIntegerDigits;
    }

    public void setMinFractionDigits(int minFractionDigits) {
        this._minFractionDigits = minFractionDigits;
    }

    public void setMaxFractionDigits(int maxFractionDigits) {
        this._maxFractionDigits = maxFractionDigits;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    public int doEndTag() throws JspException {
        try {
            String value;
            PageContextImpl pc = (PageContextImpl)this.pageContext;
            JspWriter out = pc.getOut();
            NumberFormat format = this.getFormat();
            BodyContentImpl body = (BodyContentImpl)this.getBodyContent();
            double rawValue = this._hasValue ? this._value : (body != null ? (!(value = body.getTrimString()).equals("") ? Double.parseDouble(value) : 0.0) : 0.0);
            if (Double.isNaN(rawValue)) {
                rawValue = 0.0;
            }
            value = format != null ? format.format(rawValue) : String.valueOf(rawValue);
            if (this._var == null) {
                out.print(value);
            } else {
                CoreSetTag.setValue(this.pageContext, this._var, this._scope, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return 6;
    }

    protected NumberFormat getFormat() throws JspException {
        PageContextImpl pc = (PageContextImpl)this.pageContext;
        NumberFormat format = null;
        Locale locale = pc.getLocale();
        String type = this._type;
        if (type == null || type.equals("") || type.equals("number")) {
            format = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance();
            DecimalFormat decimalFormat = (DecimalFormat)format;
            if (this._pattern != null) {
                decimalFormat.applyPattern(this._pattern);
            }
        } else if (type.equals("percent")) {
            format = locale != null ? NumberFormat.getPercentInstance(locale) : NumberFormat.getPercentInstance();
        } else if (type.equals("currency")) {
            format = locale != null ? NumberFormat.getCurrencyInstance(locale) : NumberFormat.getCurrencyInstance();
            if ((this._currencyCode != null || this._currencySymbol != null) && format instanceof DecimalFormat) {
                DecimalFormat dFormat = (DecimalFormat)format;
                DecimalFormatSymbols dSymbols = dFormat.getDecimalFormatSymbols();
                if (this._currencyCode != null && dSymbols != null) {
                    dSymbols.setInternationalCurrencySymbol(this._currencyCode);
                }
                if (this._currencySymbol != null && dSymbols != null) {
                    dSymbols.setCurrencySymbol(this._currencySymbol);
                }
                dFormat.setDecimalFormatSymbols(dSymbols);
            }
        } else {
            throw new JspException(L.l("unknown formatNumber type `{0}'", type));
        }
        format.setGroupingUsed(this._groupingUsed);
        if (this._minIntegerDigits > 0) {
            format.setMinimumIntegerDigits(this._minIntegerDigits);
        }
        if (this._maxIntegerDigits > 0) {
            format.setMaximumIntegerDigits(this._maxIntegerDigits);
        }
        if (this._minFractionDigits > 0) {
            format.setMinimumFractionDigits(this._minFractionDigits);
        }
        if (this._maxFractionDigits > 0) {
            format.setMaximumFractionDigits(this._maxFractionDigits);
        }
        return format;
    }
}

