/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jstl.el;

import com.caucho.el.Expr;
import com.caucho.jsp.PageContextImpl;
import com.caucho.jstl.el.CoreSetTag;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class FormatDateTag
extends BodyTagSupport {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jstl/el/FormatDateTag"));
    private Expr _valueExpr;
    private Expr _typeExpr;
    private Expr _dateStyleExpr;
    private Expr _timeStyleExpr;
    private Expr _patternExpr;
    private Expr _timeZoneExpr;
    private String _var;
    private String _scope;

    public void setValue(Expr value) {
        this._valueExpr = value;
    }

    public void setType(Expr type) {
        this._typeExpr = type;
    }

    public void setDateStyle(Expr style) {
        this._dateStyleExpr = style;
    }

    public void setTimeStyle(Expr style) {
        this._timeStyleExpr = style;
    }

    public void setPattern(Expr pattern) {
        this._patternExpr = pattern;
    }

    public void setTimeZone(Expr zone) {
        this._timeZoneExpr = zone;
    }

    public void setVar(String var) {
        this._var = var;
    }

    public void setScope(String scope) {
        this._scope = scope;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int doEndTag() throws JspException {
        try {
            TimeZone timeZone;
            PageContextImpl pageContext = (PageContextImpl)this.pageContext;
            JspWriter out = pageContext.getOut();
            Object value = this._valueExpr.evalObject(pageContext);
            if (value == null) {
                if (this._var == null) return 6;
                CoreSetTag.setValue(pageContext, this._var, this._scope, null);
                return 6;
            }
            long time = 0L;
            if (value instanceof Number) {
                time = ((Number)value).longValue();
            } else if (value instanceof Date) {
                time = ((Date)value).getTime();
            }
            DateFormat format = null;
            Locale locale = pageContext.getLocale();
            String type = null;
            if (this._typeExpr != null) {
                type = this._typeExpr.evalString(pageContext);
            }
            int dateStyle = 2;
            if (this._dateStyleExpr != null) {
                dateStyle = FormatDateTag.getDateStyle(this._dateStyleExpr.evalString(pageContext));
            }
            int timeStyle = 2;
            if (this._timeStyleExpr != null) {
                timeStyle = FormatDateTag.getDateStyle(this._timeStyleExpr.evalString(pageContext));
            }
            if (locale != null) {
                if (type == null || type.equals("date")) {
                    format = DateFormat.getDateInstance(dateStyle, locale);
                } else if (type.equals("both")) {
                    format = DateFormat.getDateTimeInstance(dateStyle, timeStyle, locale);
                } else {
                    if (!type.equals("time")) throw new JspException(L.l("illegal type `{0}'", type));
                    format = DateFormat.getTimeInstance(timeStyle, locale);
                }
            } else if (type == null || type.equals("date")) {
                format = DateFormat.getDateInstance(dateStyle);
            } else if (type.equals("both")) {
                format = DateFormat.getDateTimeInstance(dateStyle, timeStyle);
            } else {
                if (!type.equals("time")) throw new JspException(L.l("illegal type `{0}'", type));
                format = DateFormat.getTimeInstance(timeStyle);
            }
            if (format != null && this._patternExpr != null) {
                String pattern = this._patternExpr.evalString(pageContext);
                try {
                    ((SimpleDateFormat)format).applyPattern(pattern);
                }
                catch (ClassCastException e) {
                    format = new SimpleDateFormat(pattern, locale);
                }
            }
            if (format != null && (timeZone = this.getTimeZone()) != null) {
                format.setTimeZone(timeZone);
            }
            if (format != null) {
                value = format.format(new Date(time));
            }
            if (this._var == null) {
                out.print(value);
                return 6;
            } else {
                CoreSetTag.setValue(pageContext, this._var, this._scope, value);
            }
            return 6;
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    private TimeZone getTimeZone() throws ELException {
        PageContextImpl pageContext;
        Object timeZoneObj;
        TimeZone zone;
        if (this._timeZoneExpr != null && (zone = this.getTimeZone(timeZoneObj = this._timeZoneExpr.evalObject(pageContext = (PageContextImpl)this.pageContext))) != null) {
            return zone;
        }
        Object timeZoneObj2 = this.pageContext.getAttribute("com.caucho.time-zone");
        if (timeZoneObj2 != null) {
            return (TimeZone)timeZoneObj2;
        }
        timeZoneObj2 = Config.find((PageContext)this.pageContext, (String)"javax.servlet.jsp.jstl.fmt.timeZone");
        return this.getTimeZone(timeZoneObj2);
    }

    private TimeZone getTimeZone(Object timeZoneObj) {
        if (timeZoneObj instanceof TimeZone) {
            return (TimeZone)timeZoneObj;
        }
        if (timeZoneObj instanceof String) {
            String timeZoneString = (String)timeZoneObj;
            return TimeZone.getTimeZone(timeZoneString);
        }
        return null;
    }

    public static int getDateStyle(String style) throws JspException {
        if (style == null || style.equals("default")) {
            return 2;
        }
        if (style.equals("short")) {
            return 3;
        }
        if (style.equals("medium")) {
            return 2;
        }
        if (style.equals("long")) {
            return 1;
        }
        if (style.equals("full")) {
            return 0;
        }
        throw new JspException(L.l("illegal date style `{0}'", style));
    }
}

