/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.log.Log;
import com.caucho.server.connection.CauchoRequest;
import com.caucho.server.webapp.Application;
import com.caucho.util.Alarm;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.xsl.AbstractStylesheetFactory;
import com.caucho.xsl.StyleScript;
import com.caucho.xsl.StylesheetImpl;
import com.caucho.xsl.Xsl;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.Templates;

class XslManager {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/XslManager"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/XslManager"));
    private Application _application;
    private Path _workPath;
    private LruCache<String, SoftReference<Templates>> _xslCache = new LruCache(256);
    private boolean _strictXsl;
    private long _lastUpdate;

    public XslManager(ServletContext context) {
        this._application = (Application)context;
        this._workPath = CauchoSystem.getWorkPath();
    }

    public void setStrictXsl(boolean strictXsl) {
        this._strictXsl = strictXsl;
    }

    public String getServletInfo() {
        return "Resin XTP";
    }

    Templates get(String href, CauchoRequest req) throws Exception {
        String servletPath = req.getPageServletPath();
        Application application = req.getApplication();
        Path appDir = application.getAppDir();
        Path pwd = appDir.lookupNative(application.getRealPath(servletPath));
        pwd = pwd.getParent();
        String fullStyleSheet = pwd.toString() + "/" + href;
        Templates stylesheet = null;
        long now = Alarm.getCurrentTime();
        SoftReference<Templates> templateRef = this._xslCache.get(fullStyleSheet);
        if (templateRef != null) {
            stylesheet = templateRef.get();
        }
        if (stylesheet instanceof StylesheetImpl && !((StylesheetImpl)stylesheet).isModified()) {
            return stylesheet;
        }
        this._lastUpdate = now;
        stylesheet = this.getStylesheet(req, href);
        if (stylesheet == null) {
            throw new ServletException(L.l("can't find stylesheet `{0}'", href));
        }
        this._xslCache.put(fullStyleSheet, new SoftReference<Templates>(stylesheet));
        return stylesheet;
    }

    Templates getStylesheet(CauchoRequest req, String href) throws Exception {
        int p;
        String servletPath = req.getPageServletPath();
        Application application = req.getApplication();
        Path appDir = application.getAppDir();
        Path pwd = appDir.lookupNative(application.getRealPath(servletPath));
        pwd = pwd.getParent();
        MergePath stylePath = new MergePath();
        stylePath.addMergePath(pwd);
        stylePath.addMergePath(appDir);
        EnvironmentClassLoader loader = application.getClassLoader();
        String resourcePath = loader.getResourcePathSpecificFirst();
        stylePath.addClassPath(resourcePath);
        AbstractStylesheetFactory factory = this._strictXsl ? new Xsl() : new StyleScript();
        factory.setStylePath(stylePath);
        factory.setClassLoader(application.getClassLoader());
        factory.setWorkPath(this._workPath);
        String className = "";
        if (pwd.lookup(href).canRead() && (p = req.getServletPath().lastIndexOf(47)) >= 0) {
            className = className + req.getServletPath().substring(0, p);
        }
        className = className + "/" + href;
        factory.setClassName(className);
        return factory.newTemplates(href);
    }
}

