/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.JspCompiler;
import com.caucho.jsp.JspCompilerInstance;
import com.caucho.jsp.JspParseException;
import com.caucho.jsp.JspResourceManager;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.SimpleLoader;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.jsp.tagext.TagInfo;

public class TagFileManager {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jsp/TagFileManager"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/TagFileManager"));
    private JspCompiler _jspCompiler;
    private JspResourceManager _resourceManager;

    public TagFileManager(JspCompiler compiler) throws JspParseException, IOException {
        this._jspCompiler = compiler;
        this._resourceManager = this._jspCompiler.getResourceManager();
    }

    public TagInfo getTag(String shortName, String location) throws JspParseException {
        if (location == null) {
            return null;
        }
        try {
            String uri;
            TagInfo tag;
            if (location.startsWith("urn:jsptagdir:")) {
                location = location.substring("urn:jsptagdir:".length());
            }
            if (!location.endsWith("/")) {
                location = location + "/";
            }
            if ((tag = this.getTag(uri = location + shortName + ".tag")) != null) {
                return tag;
            }
            uri = location + shortName + ".tagx";
            return this.getTag(uri);
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public TagInfo getTag(String location) throws JspParseException {
        if (this._resourceManager == null) {
            return null;
        }
        Path path = this._resourceManager.resolvePath(location);
        return this.getTag(path, location);
    }

    public TagInfo getTag(Path path, String location) throws JspParseException {
        if (!path.canRead()) {
            return null;
        }
        try {
            if (location.endsWith(".tag")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(false);
                return tagCompiler.compileTag();
            }
            if (location.endsWith(".tagx")) {
                JspCompilerInstance tagCompiler = this._jspCompiler.getCompilerInstance(path, location);
                tagCompiler.setXML(true);
                return tagCompiler.compileTag();
            }
            throw new JspParseException(L.l("tag file `{0}' must end with .tag or .tagx", location));
        }
        catch (Exception e) {
            throw JspParseException.create(e);
        }
    }

    public Class loadClass(String className) throws Exception {
        Path classDir = this._jspCompiler.getClassDir();
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        DynamicClassLoader jspLoader = SimpleLoader.create(parentLoader, classDir, null);
        return Class.forName(className, false, jspLoader);
    }
}

