/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.java.JavaCompiler;
import com.caucho.jsp.Page;
import com.caucho.jsp.cfg.JspPropertyGroup;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.log.Log;
import com.caucho.make.PersistentDependency;
import com.caucho.server.webapp.Application;
import com.caucho.util.CacheListener;
import com.caucho.util.CauchoSystem;
import com.caucho.util.LruCache;
import com.caucho.vfs.MemoryPath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PageManager {
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/PageManager"));
    protected Application _application;
    private Path _classDir;
    private long _updateInterval = 1000L;
    private boolean _isAdapter;
    private boolean _omitInitLog;
    private int _jspMax = 1024;
    private LruCache<String, SoftReference<Entry>> _cache;
    protected boolean _autoCompile = true;

    abstract Page createPage(Path var1, String var2, String var3, ArrayList<PersistentDependency> var4) throws Exception;

    PageManager(Application application) {
        JspPropertyGroup jspPropertyGroup;
        this._application = application;
        this._classDir = CauchoSystem.getWorkPath();
        long interval = 15000L;
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof DynamicClassLoader)) continue;
            interval = ((DynamicClassLoader)loader).getDependencyCheckInterval();
            break;
        }
        if ((jspPropertyGroup = this._application.getJsp()) != null) {
            this._autoCompile = jspPropertyGroup.isAutoCompile();
            this._jspMax = jspPropertyGroup.getJspMax();
            if (jspPropertyGroup.getDependencyCheckInterval() != Long.MIN_VALUE) {
                interval = jspPropertyGroup.getDependencyCheckInterval();
            }
        }
        if (interval < 0L) {
            interval = 0x3FFFFFFFL;
        }
        this._updateInterval = interval;
    }

    public Path getClassDir() {
        if (this._classDir != null) {
            return this._classDir;
        }
        Path appDir = this._application.getAppDir();
        if (appDir instanceof MemoryPath) {
            String workPathName = new StringBuffer().append("./").append(this._application.getURL()).toString();
            Path path = CauchoSystem.getWorkPath().lookup(workPathName);
            return path;
        }
        return appDir.lookup("WEB-INF/work");
    }

    public Path getAppDir() {
        return this._application.getAppDir();
    }

    Application getApplication() {
        return this._application;
    }

    public Page getPage(String uri, Path path) throws Exception {
        return this.getPage(uri, uri, path, null);
    }

    public Page getPage(String uri, String pageURI, Path path) throws Exception {
        return this.getPage(uri, pageURI, path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(String uri, String pageURI, Path path, ArrayList<PersistentDependency> dependList) throws Exception {
        Page page;
        Entry entry;
        SoftReference<Entry> entryRef;
        LruCache<String, SoftReference<Entry>> cache = this._cache;
        if (cache == null) {
            PageManager pageManager = this;
            synchronized (pageManager) {
                if (this._cache == null) {
                    this._cache = new LruCache(this._jspMax);
                }
                cache = this._cache;
            }
        }
        if ((entryRef = cache.get(uri)) == null || (entry = entryRef.get()) == null) {
            LruCache<String, SoftReference<Entry>> lruCache = cache;
            synchronized (lruCache) {
                entryRef = cache.get(uri);
                if (entryRef == null || (entry = entryRef.get()) == null) {
                    entry = new Entry();
                    cache.put(uri, new SoftReference<Entry>(entry));
                }
            }
        }
        if ((page = entry.getPage()) != null && !page.cauchoIsModified()) {
            return page;
        }
        Entry entry2 = entry;
        synchronized (entry2) {
            String className;
            page = entry.getPage();
            if (page != null && !page.cauchoIsModified()) {
                return page;
            }
            if (page != null && !page.isDead()) {
                try {
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(new StringBuffer().append("uri:").append(uri).append("(cp:").append(this._application.getContextPath()).append(",app:").append(this._application.getAppDir()).append(") -> ").append(path).toString());
            }
            Path appDir = this.getApplication().getAppDir();
            String rawClassName = pageURI;
            if (path.getPath().startsWith(appDir.getPath())) {
                rawClassName = path.getPath().substring(appDir.getPath().length());
            }
            if ((page = this.createPage(path, pageURI, className = JavaCompiler.mangleName(new StringBuffer().append("jsp/").append(rawClassName).toString()), dependList)) == null) {
                return null;
            }
            if (!this._autoCompile) {
                page._caucho_setNeverModified(true);
            }
            page._caucho_setUpdateInterval(this._updateInterval);
            entry.setPage(page);
            return page;
        }
    }

    void killPage(HttpServletRequest request, HttpServletResponse response, Page page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        LruCache<String, SoftReference<Entry>> cache = this._cache;
        this._cache = null;
        if (cache == null) {
            return;
        }
        LruCache<String, SoftReference<Entry>> lruCache = cache;
        synchronized (lruCache) {
            Iterator<SoftReference<Entry>> iter = cache.values();
            while (iter.hasNext()) {
                SoftReference<Entry> entryRef = iter.next();
                if (entryRef == null) continue;
                Entry entry = entryRef.get();
                Page page = entry != null ? entry.getPage() : null;
                try {
                    if (page == null || page.isDead()) continue;
                    page.destroy();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
    }

    static class Entry
    implements CacheListener {
        private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jsp/PageManager$Entry"));
        Page _page;

        Entry() {
        }

        void setPage(Page page) {
            this._page = page;
        }

        Page getPage() {
            return this._page;
        }

        public void removeEvent() {
            Page page = this._page;
            this._page = null;
            if (page != null && !page.isDead()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("dropping page " + page);
                }
                page.setDead();
                page.destroy();
            }
        }
    }
}

