/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jsp;

import com.caucho.jsp.AbstractJspWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;

abstract class AbstractBodyContent
extends AbstractJspWriter {
    private static final char[] _trueChars = "true".toCharArray();
    private static final char[] _falseChars = "false".toCharArray();
    private static final char[] _nullChars = "null".toCharArray();
    private final char[] _tempCharBuffer = new char[256];

    public abstract void write(char[] var1, int var2, int var3) throws IOException;

    public abstract void write(int var1) throws IOException;

    public abstract void clear() throws IOException;

    public abstract void clearBuffer() throws IOException;

    public abstract void flushBuffer() throws IOException;

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public abstract int getBufferSize();

    public abstract int getRemaining();

    AbstractBodyContent() {
    }

    public final void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public final void write(String s) throws IOException {
        this.write(s, 0, s.length());
    }

    public void write(String s, int off, int len) throws IOException {
        while (len > 0) {
            int sublen = this._tempCharBuffer.length;
            if (len < sublen) {
                sublen = len;
            }
            s.getChars(off, off + sublen, this._tempCharBuffer, 0);
            this.write(this._tempCharBuffer, 0, sublen);
            len -= sublen;
            off += sublen;
        }
    }

    public void newLine() throws IOException {
        this.write(10);
    }

    public final void print(boolean b) throws IOException {
        this.write(b ? _trueChars : _falseChars);
    }

    public void print(char ch) throws IOException {
        this.write(ch);
    }

    public void print(int i) throws IOException {
        if (i == Integer.MIN_VALUE) {
            this.print("-2147483648");
            return;
        }
        if (i < 0) {
            this.write(45);
            i = -i;
        } else if (i < 9) {
            this.write(48 + i);
            return;
        }
        int length = 0;
        int exp = 10;
        if (i >= 1000000000) {
            length = 9;
        } else {
            while (i >= exp) {
                exp = 10 * exp;
                ++length;
            }
        }
        int j = 31;
        while (i > 0) {
            this._tempCharBuffer[--j] = (char)(i % 10 + 48);
            i /= 10;
        }
        this.write(this._tempCharBuffer, j, 31 - j);
    }

    public void print(long v) throws IOException {
        if (v == Long.MIN_VALUE) {
            this.print("-9223372036854775808");
            return;
        }
        if (v < 0L) {
            this.write(45);
            v = -v;
        } else if (v == 0L) {
            this.write(48);
            return;
        }
        int j = 31;
        while (v > 0L) {
            this._tempCharBuffer[--j] = (char)(v % 10L + 48L);
            v /= 10L;
        }
        this.write(this._tempCharBuffer, j, 31 - j);
    }

    public final void print(float f) throws IOException {
        this.write(String.valueOf(f));
    }

    public final void print(double d) throws IOException {
        this.write(String.valueOf(d));
    }

    public final void print(char[] s) throws IOException {
        this.write(s, 0, s.length);
    }

    public final void print(String s) throws IOException {
        if (s == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            this.write(s, 0, s.length());
        }
    }

    public final void print(Object v) throws IOException {
        if (v == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            String s = v.toString();
            this.write(s, 0, s.length());
        }
    }

    public void println() throws IOException {
        this.write(10);
    }

    public final void println(boolean v) throws IOException {
        this.print(v);
        this.println();
    }

    public final void println(char v) throws IOException {
        this.print(v);
        this.println();
    }

    public final void println(int v) throws IOException {
        this.print(v);
        this.println();
    }

    public final void println(long v) throws IOException {
        this.print(v);
        this.println();
    }

    public final void println(float v) throws IOException {
        String s = String.valueOf(v);
        this.write(s, 0, s.length());
        this.println();
    }

    public final void println(double v) throws IOException {
        String s = String.valueOf(v);
        this.write(s, 0, s.length());
        this.println();
    }

    public final void println(char[] s) throws IOException {
        this.write(s, 0, s.length);
        this.println();
    }

    public final void println(String s) throws IOException {
        if (s == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            this.write(s, 0, s.length());
        }
        this.println();
    }

    public final void println(Object v) throws IOException {
        if (v == null) {
            this.write(_nullChars, 0, _nullChars.length);
        } else {
            String s = v.toString();
            this.write(s, 0, s.length());
        }
        this.println();
    }

    public void writeOut(Writer writer) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getString() {
        throw new UnsupportedOperationException();
    }

    public Reader getReader() {
        throw new UnsupportedOperationException();
    }

    public void clearBody() {
        throw new UnsupportedOperationException();
    }
}

