/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.config.BuilderProgram;
import com.caucho.config.ConfigException;
import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class MBeanConfig {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jmx/MBeanConfig"));
    private Class _type;
    private String _mbeanName;
    private Class _interface;
    private String _jndiName;
    private ObjectName _name;
    private MBeanInfo _mbeanInfo;
    private ArrayList<BuilderProgram> _args = new ArrayList();
    private boolean _isInit;

    public void setJndiName(String name) {
        this._jndiName = name;
    }

    public String getJndiName() {
        return this._jndiName;
    }

    public void setName(String name) {
        this._mbeanName = name;
    }

    public String getName() {
        return this._mbeanName;
    }

    public void setType(Class mbeanClass) {
        this._type = mbeanClass;
    }

    public Class getMBeanClass() {
        return this._type;
    }

    public void setInterface(Class cl) {
        this._interface = cl;
    }

    public void addArg(BuilderProgram builder) {
        this._args.add(builder);
    }

    public void init() throws Throwable {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        if (this._mbeanName == null) {
            throw new ConfigException(L.l("<mbean> configuration needs a 'name' attribute.  The 'name' is the MBean ObjectName for the bean."));
        }
        AbstractMBeanServer server = Jmx.getMBeanServer();
        this._name = Jmx.getObjectName(this._mbeanName);
        if (this._type == null) {
            if (server.getMBeanInfo(this._name) != null) {
                return;
            }
            throw new ConfigException(L.l("<mbean> configuration needs a 'type' attribute.  The 'class' is the class name of the resource bean."));
        }
        Constructor constructor = this.getConstructor(this._args.size());
        Class<?>[] params = constructor.getParameterTypes();
        Object[] args = new Object[this._args.size()];
        for (int i = 0; i < args.length; ++i) {
            args[0] = this._args.get(i).configure(params[i]);
        }
        Object obj = constructor.newInstance(args);
        if (this._interface != null) {
            IntrospectionMBean mbean = new IntrospectionMBean(obj, this._interface);
            server.registerMBean(mbean, this._name);
        } else {
            server.registerMBean(obj, this._name);
        }
        this._mbeanInfo = server.getMBeanInfo(this._name);
    }

    ObjectName getObjectName() throws Throwable {
        if (this._name == null) {
            this.init();
        }
        return this._name;
    }

    private Constructor getConstructor(int len) throws Throwable {
        Constructor<?>[] constructors = this._type.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != len) continue;
            return constructors[i];
        }
        throw new ConfigException(L.l("`{0}' has no matching constructors.", this._type.getName()));
    }

    MBeanInfo getMBeanInfo() throws Throwable {
        if (this._mbeanInfo == null) {
            this.init();
        }
        return this._mbeanInfo;
    }

    public Init createInit() {
        return new Init();
    }

    public Listener createListener() {
        return new Listener();
    }

    public String toString() {
        return "MBean[" + this._mbeanName + "]";
    }

    public class Listener {
        private String _name;
        private Object _handback;
        private NotificationFilter _filter;

        public void setName(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setHandback(Object handback) {
            this._handback = handback;
        }

        public Object getHandback() {
            return this._handback;
        }

        public void init() throws Throwable {
            ObjectName mbeanName = MBeanConfig.this.getObjectName();
            ObjectName listenerName = Jmx.getObjectName(this._name);
            AbstractMBeanServer server = Jmx.getMBeanServer();
            server.addNotificationListener(mbeanName, listenerName, this._filter, this._handback);
        }
    }

    public class Init {
        public void setProperty(String attrName, BuilderProgram program) throws Throwable {
            MBeanAttributeInfo attr = this.getAttribute(attrName);
            if (attr == null) {
                throw new ConfigException(L.l("`{0}' is an unknown attribute for {1}", (Object)attrName, MBeanConfig.this._mbeanName));
            }
            String typeName = attr.getType();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> type = Class.forName(typeName, false, loader);
            Object value = program.configure(type);
            AbstractMBeanServer server = Jmx.getMBeanServer();
            server.setAttribute(MBeanConfig.this._name, new Attribute(attrName, value));
        }

        private MBeanAttributeInfo getAttribute(String key) throws Throwable {
            MBeanInfo info = MBeanConfig.this.getMBeanInfo();
            MBeanAttributeInfo[] attrs = info.getAttributes();
            if (attrs == null) {
                return null;
            }
            for (int i = 0; i < attrs.length; ++i) {
                if (!attrs[i].getName().equals(key)) continue;
                return attrs[i];
            }
            return null;
        }
    }
}

