/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jmx;

import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.IntrospectionMBean;
import com.caucho.jmx.Jmx;
import com.caucho.jmx.MBeanContext;
import com.caucho.jmx.MBeanServerDelegateImpl;
import com.caucho.jmx.MBeanWrapper;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerDelegate;

public class EnvironmentMBeanServer
extends AbstractMBeanServer {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jmx/EnvironmentMBeanServer"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jmx/EnvironmentMBeanServer"));
    private EnvironmentLocal<MBeanContext> _localContext = new EnvironmentLocal();
    private MBeanServerDelegate _globalDelegate;

    public EnvironmentMBeanServer(String domain, MBeanServerDelegate delegate) {
        super(domain);
        if (Jmx.getMBeanServer() == null) {
            Jmx.setMBeanServer(this);
        }
        ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
        MBeanContext context = new MBeanContext(this, systemLoader, delegate);
        this._localContext.set(context, systemLoader);
        try {
            IntrospectionMBean mbean = new IntrospectionMBean(delegate, ClassLiteral.getClass((String)"javax/management/MBeanServerDelegateMBean"));
            MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
            context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanContext getContext(ClassLoader loader) {
        if (loader == null) {
            return this._localContext.get(ClassLoader.getSystemClassLoader());
        }
        EnvironmentLocal<MBeanContext> environmentLocal = this._localContext;
        synchronized (environmentLocal) {
            MBeanContext context = this._localContext.getLevel(loader);
            if (context == null) {
                MBeanServerDelegateImpl delegate = new MBeanServerDelegateImpl("Resin-JMX");
                context = new MBeanContext(this, loader, delegate);
                MBeanContext parent = this.getContext(loader.getParent());
                if (parent != null) {
                    context.setProperties(parent.copyProperties());
                }
                this._localContext.set(context, loader);
                try {
                    IntrospectionMBean mbean = new IntrospectionMBean(delegate, ClassLiteral.getClass((String)"javax/management/MBeanServerDelegateMBean"));
                    MBeanWrapper mbeanWrapper = new MBeanWrapper(context, SERVER_DELEGATE_NAME, delegate, mbean);
                    context.registerMBean(mbeanWrapper, SERVER_DELEGATE_NAME);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            return context;
        }
    }

    protected void removeContext(MBeanContext context, ClassLoader loader) {
        if (this._localContext.get(loader) == context) {
            this._localContext.remove(loader);
        }
    }

    public String toString() {
        return "EnvironmentMBeanServer[]";
    }
}

