/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.session;

import com.caucho.jms.ConnectionFactoryImpl;
import com.caucho.jms.session.ConnectionMetaDataImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionMetaData;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidClientIDException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class ConnectionImpl
implements Connection {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/session/ConnectionImpl"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/session/ConnectionImpl"));
    private static int _clientIdGenerator;
    private ConnectionFactoryImpl _factory;
    private String _clientId;
    private boolean _isClientIdSet;
    private ExceptionListener _exceptionListener;
    private ArrayList<SessionImpl> _sessions = new ArrayList();
    private HashMap<String, TopicSubscriber> _durableSubscriberMap = new HashMap();
    private volatile boolean _isActive;
    private volatile boolean _isStopping;
    protected volatile boolean _isClosed;

    public ConnectionImpl(ConnectionFactoryImpl factory) {
        this._factory = factory;
    }

    public String getClientID() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        return this._clientId;
    }

    public void setClientID(String clientId) throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        if (this._isClientIdSet) {
            throw new IllegalStateException(L.l("Can't set client id '{0}' after the connection has been used.", clientId));
        }
        ConnectionImpl oldConn = this._factory.findByClientID(clientId);
        if (oldConn != null) {
            throw new InvalidClientIDException(L.l("'{0}' is a duplicate client id.", clientId));
        }
        this._clientId = clientId;
        this._isClientIdSet = true;
    }

    public ConnectionFactoryImpl getConnectionFactory() {
        return this._factory;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        this.assignClientID();
        this._exceptionListener = listener;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        return new ConnectionMetaDataImpl();
    }

    public void start() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        this.assignClientID();
        if (this._isActive || this._isStopping) {
            return;
        }
        this._isActive = true;
        for (int i = 0; i < this._sessions.size(); ++i) {
            this._sessions.get(i).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        if (this._isStopping || !this._isActive) {
            return;
        }
        this.assignClientID();
        this._isStopping = true;
        try {
            for (int i = 0; i < this._sessions.size(); ++i) {
                this._sessions.get(i).stop();
            }
        }
        finally {
            this._isActive = false;
            this._isStopping = false;
        }
    }

    boolean isActive() {
        return this._isActive;
    }

    boolean isStopping() {
        return this._isStopping;
    }

    public Session createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkOpen();
        this.assignClientID();
        return new SessionImpl(this, transacted, acknowledgeMode);
    }

    protected void addSession(SessionImpl session) {
        this._sessions.add(session);
        if (this._isActive) {
            session.start();
        }
    }

    void removeSession(SessionImpl session) {
        this._sessions.remove(session);
    }

    TopicSubscriber getDurableSubscriber(String name) {
        return this._durableSubscriberMap.get(name);
    }

    TopicSubscriber putDurableSubscriber(String name, TopicSubscriber subscriber) {
        return this._durableSubscriberMap.put(name, subscriber);
    }

    TopicSubscriber removeDurableSubscriber(String name) {
        return this._durableSubscriberMap.remove(name);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw new UnsupportedOperationException();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String name, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
        throw new UnsupportedOperationException();
    }

    public void close() throws JMSException {
        if (this._isClosed) {
            return;
        }
        this.stop();
        this._isClosed = true;
        this._factory.removeConnection(this);
        ArrayList<SessionImpl> sessions = new ArrayList<SessionImpl>(this._sessions);
        this._sessions.clear();
        for (int i = 0; i < sessions.size(); ++i) {
            try {
                sessions.get(i).close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    protected void checkOpen() throws IllegalStateException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("connection is closed"));
        }
    }

    protected void assignClientID() {
        if (this._clientId == null) {
            this._clientId = "resin-temp-" + _clientIdGenerator++;
        }
        this._isClientIdSet = true;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

