/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.message;

import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.message.MessageImpl;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;

public class ObjectMessageImpl
extends MessageImpl
implements ObjectMessage {
    private TempStream _tempStream;

    public void setObject(Serializable o) throws JMSException {
        this.checkBodyWriteable();
        this._tempStream = new TempStream(null);
        try {
            WriteStream ws = new WriteStream(this._tempStream);
            ObjectOutputStream oos = new ObjectOutputStream(ws);
            oos.writeObject(o);
            oos.close();
            ws.close();
        }
        catch (Exception e) {
            throw JMSExceptionWrapper.create(e);
        }
    }

    public Serializable getObject() throws JMSException {
        if (this._tempStream == null) {
            return null;
        }
        try {
            ReadStream is = this._tempStream.openRead(false);
            ObjectInputStream ois = new ObjectInputStream(is);
            Serializable object = (Serializable)ois.readObject();
            ois.close();
            is.close();
            return object;
        }
        catch (Exception e) {
            throw JMSExceptionWrapper.create(e);
        }
    }

    public void clearBody() throws JMSException {
        super.clearBody();
        this._tempStream = null;
    }

    public MessageImpl copy() {
        ObjectMessageImpl msg = new ObjectMessageImpl();
        this.copy(msg);
        msg._tempStream = this._tempStream;
        return msg;
    }
}

