/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.memory;

import com.caucho.jms.memory.MemoryQueue;
import com.caucho.jms.memory.MemoryTopic;
import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.session.MessageConsumerImpl;
import com.caucho.jms.session.SessionImpl;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MemoryTopicConsumer
extends MessageConsumerImpl
implements TopicSubscriber {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryTopicConsumer"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/memory/MemoryTopicConsumer"));
    private MemoryTopic _topic;
    private MemoryQueue _queue;
    private int _consumerId;
    private boolean _autoAck;

    public MemoryTopicConsumer(SessionImpl session, String messageSelector, MemoryTopic topic) throws JMSException {
        this(session, messageSelector, topic, null);
    }

    public MemoryTopicConsumer(SessionImpl session, String messageSelector, MemoryTopic topic, String name) throws JMSException {
        block3: {
            block2: {
                super(session, messageSelector, topic, false);
                this._topic = topic;
                if (session.getAcknowledgeMode() == 1) break block2;
                if (session.getAcknowledgeMode() != 3) break block3;
            }
            this._autoAck = true;
        }
        this._queue = name != null ? topic.createDurableSubscriber(name) : topic.createSubscriberQueue();
        this._queue.addListener(this);
    }

    public Topic getTopic() {
        return this._topic;
    }

    protected MessageImpl receiveImpl() throws JMSException {
        return this._queue.receive(this._selector, 1L, true);
    }

    public void acknowledge() throws JMSException {
        if (this._autoAck) {
            return;
        }
    }

    public void rollback() throws JMSException {
        if (this._autoAck) {
            return;
        }
    }

    public void close() {
        this._topic.removeSubscriber(this._queue);
    }

    public String toString() {
        return "MemoryTopicConsumer[" + this._topic + "," + this._consumerId + "]";
    }
}

