/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.log;

import com.caucho.config.ConfigException;
import com.caucho.jms.AbstractDestination;
import com.caucho.jms.JMSExceptionWrapper;
import com.caucho.jms.selector.Selector;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;

public class LogQueue
extends AbstractDestination
implements Queue {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/log/LogQueue"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/log/LogQueue"));
    private static final byte[] RESIN = new byte[]{82, 69, 83, 73, 78};
    ArrayList<Message> _queue = new ArrayList();
    private String _queueName;
    private Selector _selector;
    private Path _basePath;
    private long _logFileSize = 0xA00000L;
    private Path _pathA;
    private long _lengthA;
    private TempOutputStream _tempA = new TempOutputStream();
    private WriteStream _writeA;
    private TempStream _outA = new TempStream();

    public void setPath(Path path) {
        this._basePath = path;
    }

    public String getQueueName() {
        return this._queueName;
    }

    public void setQueueName(String name) {
        this._queueName = name;
    }

    public void setSelector(Selector selector) {
        this._selector = selector;
    }

    public Selector getSelector() {
        return this._selector;
    }

    public void init() throws ConfigException, IOException {
        if (this._basePath == null) {
            throw new ConfigException(L.l("LogQueue requires a <path> element."));
        }
        if (this._basePath.isDirectory()) {
            throw new ConfigException(L.l("<path> must be a file prefix, not a directory."));
        }
        this._basePath.getParent().mkdirs();
        String tail = this._basePath.getTail();
        this._pathA = this._basePath.getParent().lookup(tail + "_a");
        this._lengthA = this._pathA.getLength();
        this._writeA = this._pathA.openAppend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Message message) throws JMSException {
        if (this._selector != null && !this._selector.isMatch(message)) {
            return;
        }
        long sequenceId = this.nextConsumerSequenceId();
        if (log.isLoggable(Level.FINE)) {
            log.fine("jms log queue:" + this._queueName + " send message " + sequenceId);
        }
        try {
            TempOutputStream tempOutputStream = this._tempA;
            synchronized (tempOutputStream) {
                TempBuffer ptr;
                this._tempA.clearWrite();
                this._tempA.write(83);
                int offset = this._tempA.getLength();
                this.writeInt(this._tempA, 0);
                this.writeLong(this._tempA, message.getJMSExpiration());
                ObjectOutputStream oos = new ObjectOutputStream(this._tempA);
                oos.writeObject(message);
                oos.close();
                int length = this._tempA.getLength() - offset;
                this.writeInt(this._tempA, length);
                this._tempA.write(RESIN, 0, RESIN.length);
                if (ptr != null) {
                    byte[] buffer = ptr.getBuffer();
                    buffer[1] = (byte)(length >> 24);
                    buffer[2] = (byte)(length >> 16);
                    buffer[3] = (byte)(length >> 8);
                    buffer[4] = (byte)length;
                    for (ptr = this._tempA.getHead(); ptr != null; ptr = ptr.getNext()) {
                        this._writeA.write(ptr.getBuffer(), 0, ptr.getLength());
                    }
                    this._writeA.flush();
                    this._tempA.clearWrite();
                }
            }
        }
        catch (Exception e) {
            throw new JMSExceptionWrapper(e);
        }
        this.messageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(Selector selector) throws JMSException {
        ArrayList<Message> arrayList = this._queue;
        synchronized (arrayList) {
            int size = this._queue.size();
            for (int i = 0; i < size; ++i) {
                Message message = this._queue.get(i);
                if (selector != null && !selector.isMatch(message)) continue;
                this._queue.remove(i);
                return message;
            }
        }
        return null;
    }

    public Enumeration getEnumeration(Selector selector) {
        return new BrowserEnumeration(this, selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMessage(Selector selector) throws JMSException {
        ArrayList<Message> arrayList = this._queue;
        synchronized (arrayList) {
            int size = this._queue.size();
            for (int i = 0; i < size; ++i) {
                Message message = this._queue.get(i);
                if (selector != null && !selector.isMatch(message)) continue;
                return true;
            }
        }
        return false;
    }

    private void writeInt(OutputStream os, int value) throws IOException {
        os.write(value >> 24);
        os.write(value >> 16);
        os.write(value >> 8);
        os.write(value);
    }

    private void writeLong(OutputStream os, long value) throws IOException {
        os.write((int)(value >> 56));
        os.write((int)(value >> 48));
        os.write((int)(value >> 40));
        os.write((int)(value >> 32));
        os.write((int)(value >> 24));
        os.write((int)(value >> 16));
        os.write((int)(value >> 8));
        os.write((int)value);
    }

    public String toString() {
        return "MemoryQueue[" + this._queueName + "]";
    }

    static class TempOutputStream
    extends OutputStream {
        private TempStream _tempStream = new TempStream();
        private byte[] _oneBuf = new byte[1];
        private int _length;

        TempOutputStream() {
        }

        void clearWrite() {
            this._tempStream.clearWrite();
        }

        TempBuffer getHead() {
            return this._tempStream.getHead();
        }

        public void write(int ch) throws IOException {
            ++this._length;
            this._oneBuf[0] = (byte)ch;
            this._tempStream.write(this._oneBuf, 0, 1, false);
        }

        public void write(byte[] buffer, int offset, int length) throws IOException {
            this._length += length;
            this._tempStream.write(buffer, offset, length, false);
        }

        int getLength() {
            return this._length;
        }
    }

    static class BrowserEnumeration
    implements Enumeration {
        private LogQueue _queue;
        private Selector _selector;

        BrowserEnumeration(LogQueue queue, Selector selector) {
            this._queue = queue;
            this._selector = selector;
        }

        public boolean hasMoreElements() {
            try {
                return this._queue.hasMessage(this._selector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Object nextElement() {
            try {
                return this._queue.receive(this._selector);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

