/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms.jdbc;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jms.jdbc.JdbcMessage;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class JdbcManager {
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcManager"));
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jms/jdbc/JdbcManager"));
    private DataSource _dataSource;
    private String _messageTable = "resin_jms_message";
    private String _destinationTable = "resin_jms_destination";
    private String _consumerTable = "resin_jms_consumer";
    private String _blob = "BLOB";
    private long _purgeInterval = 60000L;
    private JdbcMessage _jdbcMessage;
    private volatile boolean _isInit;

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public String getMessageTable() {
        return this._messageTable;
    }

    public void setMessageTable(String tableName) {
        this._messageTable = tableName;
    }

    public String getDestinationTable() {
        return this._destinationTable;
    }

    public void setDestinationTable(String tableName) {
        this._destinationTable = tableName;
    }

    public String getConsumerTable() {
        return this._consumerTable;
    }

    public void setConsumerTable(String tableName) {
        this._consumerTable = tableName;
    }

    public String getBlob() {
        return this._blob;
    }

    public void setPurgeInterval(Period period) {
        this._purgeInterval = period.getPeriod();
    }

    public long getPurgeInterval() {
        return this._purgeInterval;
    }

    public JdbcMessage getJdbcMessage() {
        return this._jdbcMessage;
    }

    public void init() throws ConfigException, SQLException {
        if (this._isInit) {
            return;
        }
        this._isInit = true;
        if (this._dataSource == null) {
            throw new ConfigException(L.l("JdbcManager requires a <data-source> element."));
        }
        this._jdbcMessage = new JdbcMessage(this);
        this._jdbcMessage.init();
        this.initDestinationTable();
        this.initConsumerTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDestinationTable() throws SQLException {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT 1 FROM " + this._destinationTable + " WHERE 1=0";
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                log.finest(e.toString());
                log.info(L.l("creating JMS destination table {0}", this._destinationTable));
                sql = "CREATE TABLE " + this._destinationTable + " (" + "  id BIGINT PRIMARY KEY auto_increment," + "  name VARCHAR(255)," + "  is_topic INTEGER" + ")";
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initConsumerTable() throws SQLException {
        Connection conn = this._dataSource.getConnection();
        try {
            Statement stmt = conn.createStatement();
            String sql = "SELECT 1 FROM " + this._consumerTable + " WHERE 1=0";
            try {
                ResultSet rs = stmt.executeQuery(sql);
                rs.next();
                rs.close();
                stmt.close();
                return;
            }
            catch (SQLException e) {
                log.finest(e.toString());
                log.info(L.l("creating JMS subscriber table {0}", this._consumerTable));
                sql = "CREATE TABLE " + this._consumerTable + " (" + "  s_id BIGINT PRIMARY KEY auto_increment," + "  queue BIGINT," + "  client VARCHAR(255)," + "  name VARCHAR(255)," + "  expire BIGINT," + "  read BIGINT DEFAULT(-1)," + "  ack BIGINT DEFAULT(-1)" + ")";
                stmt.executeUpdate(sql);
                conn.close();
            }
        }
        finally {
            conn.close();
        }
    }

    public int hashCode() {
        if (this._dataSource == null) {
            return 0;
        }
        return this._dataSource.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JdbcManager)) {
            return false;
        }
        JdbcManager manager = (JdbcManager)o;
        return this._dataSource != null && this._dataSource.equals(manager._dataSource);
    }
}

