/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jms;

import com.caucho.jms.message.MessageImpl;
import com.caucho.jms.message.ObjectMessageImpl;
import com.caucho.jms.message.TextMessageImpl;
import com.caucho.jms.selector.Selector;
import com.caucho.jms.session.MessageAvailableListener;
import com.caucho.jms.session.SessionImpl;
import com.caucho.loader.Environment;
import com.caucho.log.Log;
import com.caucho.services.message.MessageSender;
import com.caucho.services.message.MessageServiceException;
import com.caucho.util.Alarm;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.NullEnumeration;
import com.caucho.util.RandomUtil;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.QueueBrowser;
import javax.jms.TopicSubscriber;

public abstract class AbstractDestination
implements Destination,
MessageSender {
    protected static Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jms/AbstractDestination"));
    private String _idPrefix;
    private long _idCount;
    private volatile long _consumerSequenceId;
    private ArrayList<SoftReference<MessageAvailableListener>> _listenerRefs = new ArrayList();

    protected AbstractDestination() {
        CharBuffer cb = new CharBuffer();
        cb.append("ID:");
        Object serverId = Environment.getAttribute("caucho.server-id");
        if (serverId != null) {
            cb.append(serverId);
        }
        Base64.encode(cb, RandomUtil.getRandomLong());
        Base64.encode(cb, Alarm.getCurrentTime());
        this._idPrefix = cb.toString();
    }

    public synchronized String generateMessageID() {
        return this._idPrefix + this._idCount++;
    }

    public long getConsumerSequenceId() {
        return this._consumerSequenceId;
    }

    protected synchronized long nextConsumerSequenceId() {
        return ++this._consumerSequenceId;
    }

    public void send(Message message) throws JMSException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(MessageAvailableListener listener) {
        ArrayList<SoftReference<MessageAvailableListener>> arrayList = this._listenerRefs;
        synchronized (arrayList) {
            this._listenerRefs.add(new SoftReference<MessageAvailableListener>(listener));
        }
        listener.messageAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(MessageAvailableListener listener) {
        ArrayList<SoftReference<MessageAvailableListener>> arrayList = this._listenerRefs;
        synchronized (arrayList) {
            for (int i = this._listenerRefs.size() - 1; i >= 0; --i) {
                SoftReference<MessageAvailableListener> ref = this._listenerRefs.get(i);
                MessageAvailableListener oldListener = ref.get();
                if (oldListener == null) {
                    this._listenerRefs.remove(i);
                    continue;
                }
                if (oldListener != listener) continue;
                this._listenerRefs.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageAvailable() {
        ArrayList<SoftReference<MessageAvailableListener>> arrayList = this._listenerRefs;
        synchronized (arrayList) {
            for (int i = this._listenerRefs.size() - 1; i >= 0; --i) {
                SoftReference<MessageAvailableListener> ref = this._listenerRefs.get(i);
                MessageAvailableListener listener = ref.get();
                if (listener != null) {
                    listener.messageAvailable();
                    continue;
                }
                this._listenerRefs.remove(i);
            }
        }
    }

    public MessageConsumer createConsumer(SessionImpl session, String selector, boolean noLocal) throws JMSException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public QueueBrowser createBrowser(SessionImpl session, String selector) throws JMSException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public TopicSubscriber createDurableSubscriber(SessionImpl session, String selector, boolean noLocal, String name) throws JMSException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public Enumeration getEnumeration(Selector selector) throws JMSException {
        return NullEnumeration.create();
    }

    public void send(HashMap headers, Object data) throws MessageServiceException {
        try {
            MessageImpl message;
            MessageImpl msg;
            if (data instanceof String) {
                msg = new TextMessageImpl();
                msg.setText((String)data);
                message = msg;
            } else if (data instanceof Serializable) {
                msg = new ObjectMessageImpl();
                msg.setObject((Serializable)data);
                message = msg;
            } else {
                throw new MessageServiceException("not a serializable object: " + data);
            }
            if (headers != null) {
                Iterator iter = headers.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object value = headers.get(key);
                    message.setObjectProperty(key, value);
                }
            }
            this.send(message);
        }
        catch (MessageServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageServiceException(e);
        }
    }
}

