/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.BeanBuilder;
import com.caucho.config.ConfigException;
import com.caucho.config.TypeBuilderFactory;
import com.caucho.jca.cfg.ConfigPropertyConfig;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class ObjectConfig {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/cfg/ObjectConfig"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jca/cfg/ObjectConfig"));
    private Class _type;
    private HashMap<String, ConfigPropertyConfig> _propertyMap = new HashMap();

    public void setType(Class type) throws ConfigException {
        this._type = type;
        BeanBuilder.validateBeanClass(type);
    }

    public Class getType() {
        return this._type;
    }

    public void addConfigProperty(ConfigPropertyConfig property) throws ConfigException {
        if (this._propertyMap.get(property.getName()) != null) {
            throw new ConfigException(L.l("'{0}' is a duplicate property name.  Property names must be declared only once.", property.getName()));
        }
        this._propertyMap.put(property.getName(), property);
    }

    public Object instantiate() throws Exception {
        if (this._type == null) {
            throw new ConfigException(L.l("The type must be set for an object configuration."));
        }
        Object object = this._type.newInstance();
        Iterator<ConfigPropertyConfig> iter = this._propertyMap.values().iterator();
        while (iter.hasNext()) {
            ConfigPropertyConfig prop = iter.next();
            if (prop.getValue() == null) continue;
            TypeBuilderFactory.setAttribute(object, prop.getName(), prop.getValue());
        }
        return object;
    }
}

