/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.ConfigException;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDeploy {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/ResourceDeploy"));
    private Path _rarDir;
    private Path _rarExpandDir;
    private HashSet<String> _rarNames = new HashSet();
    private volatile boolean _isInit;

    public Path getPath() {
        return this._rarDir;
    }

    public void setPath(Path path) {
        this._rarDir = path;
    }

    public void setExpandPath(Path path) {
        this._rarExpandDir = path;
    }

    public Path getExpandPath() {
        if (this._rarExpandDir != null) {
            return this._rarExpandDir;
        }
        return this._rarDir;
    }

    public boolean isModified() {
        try {
            return !this._rarNames.equals(this.getRarNames());
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ConfigException {
        ResourceDeploy resourceDeploy = this;
        synchronized (resourceDeploy) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
        }
        if (this.getPath() == null) {
            throw new ConfigException(L.l("resource-deploy requires a path attribute"));
        }
        try {
            this._rarNames = this.getRarNames();
            for (String name : this._rarNames) {
                ResourceArchive rar = new ResourceArchive();
                rar.setRarPath(this.getPath().lookup(new StringBuffer().append(name).append(".rar").toString()));
                rar.setRootDirectory(this.getExpandPath().lookup(new StringBuffer().append("_rar_").append(name).toString()));
                rar.init();
                ResourceArchiveManager.addResourceArchive(rar);
            }
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }

    private HashSet<String> getRarNames() throws IOException {
        HashSet<String> rarNames = new HashSet<String>();
        Path rarDir = this.getPath();
        Path rarExpandDir = this.getExpandPath();
        if (rarDir == null || rarExpandDir == null) {
            return rarNames;
        }
        String[] rarDirList = rarDir.list();
        for (int i = 0; i < rarDirList.length; ++i) {
            Path path;
            String rarName = rarDirList[i];
            if (!rarName.endsWith(".rar") || !(path = rarDir.lookup(rarName)).canRead()) continue;
            String appName = rarName.substring(0, rarName.length() - 4);
            if (CauchoSystem.isCaseInsensitive()) {
                appName = appName.toLowerCase();
            }
            rarNames.add(appName);
        }
        String[] rarExpandList = rarExpandDir.list();
        ArrayList<String> newNames = new ArrayList<String>();
        for (int i = 0; i < rarExpandList.length; ++i) {
            Path path;
            String rarDirName = rarExpandList[i];
            if (!rarDirName.startsWith("_rar_")) continue;
            if (CauchoSystem.isCaseInsensitive()) {
                rarDirName = rarDirName.toLowerCase();
            }
            if (!(path = rarExpandDir.lookup(rarDirName)).isDirectory() || !rarDirName.startsWith("_rar_")) continue;
            String appName = rarDirName.substring(5);
            if (!newNames.contains(appName)) {
                newNames.add(appName);
            }
            rarNames.add(appName);
        }
        return rarNames;
    }
}

