/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.ResourceArchive;
import com.caucho.jca.cfg.ResourceAdapterConfig;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.log.Log;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ResourceArchiveManager {
    static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/jca/ResourceArchiveManager"));
    static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/jca/ResourceArchiveManager"));
    private static final EnvironmentLocal<ResourceArchiveManager> _localManager = new EnvironmentLocal();
    private ArrayList<ResourceArchive> _resources = new ArrayList();

    private ResourceArchiveManager() {
    }

    static void addResourceArchive(ResourceArchive rar) {
        ResourceArchiveManager raManager = _localManager.getLevel();
        if (raManager == null) {
            raManager = new ResourceArchiveManager();
            _localManager.set(raManager);
        }
        raManager._resources.add(rar);
    }

    static ResourceArchive findResourceArchive(String name) {
        for (ClassLoader loader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            ResourceArchive ra;
            EnvironmentClassLoader envLoader;
            ResourceArchiveManager manager;
            if (!(loader instanceof EnvironmentClassLoader) || (manager = _localManager.getLevel(envLoader = (EnvironmentClassLoader)loader)) == null || (ra = manager.getResourceArchive(name)) == null) continue;
            return ra;
        }
        return null;
    }

    private ResourceArchive getResourceArchive(String type) {
        ResourceArchive ra;
        int i;
        for (i = 0; i < this._resources.size(); ++i) {
            ra = this._resources.get(i);
            if (!type.equals(ra.getDisplayName())) continue;
            return ra;
        }
        for (i = 0; i < this._resources.size(); ++i) {
            Class resourceAdapterClass;
            ra = this._resources.get(i);
            ResourceAdapterConfig raConfig = ra.getResourceAdapter();
            if (raConfig == null || (resourceAdapterClass = raConfig.getResourceadapterClass()) == null || !type.equals(resourceAdapterClass.getName())) continue;
            return ra;
        }
        for (i = 0; i < this._resources.size(); ++i) {
            ra = this._resources.get(i);
            if (ra.getConnectionDefinition(type) == null) continue;
            return ra;
        }
        return null;
    }
}

