/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaCompiler;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.JavaClass;
import com.caucho.loader.SimpleLoader;
import com.caucho.loader.enhancer.EnhancingClassLoader;
import com.caucho.log.Log;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

public class JavaClassGenerator {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/java/gen/JavaClassGenerator"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/java/gen/JavaClassGenerator"));
    private ClassLoader _parentLoader;
    private ClassLoader _preloadLoader;
    private ClassLoader _loader;
    private Path _searchPath;
    private Path _workPath;
    private ArrayList<String> _pendingFiles = new ArrayList();
    private String _initMethod = "_caucho_init";
    private String _isModifiedMethod = "_caucho_is_modified";

    public static String cleanClassName(String className) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < className.length(); ++i) {
            char ch = className.charAt(i);
            if (ch == '.' || ch == '/') {
                cb.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(ch);
                continue;
            }
            cb.append('_');
        }
        return cb.toString();
    }

    public static Path getDefaultSearchPath() {
        MergePath mergePath = new MergePath();
        mergePath.addMergePath(Vfs.lookup());
        mergePath.addClassPath();
        return mergePath;
    }

    public void setSearchPath(Path path) {
        this._searchPath = path;
    }

    public Path getSearchPath() {
        return this._searchPath;
    }

    public void setParentLoader(ClassLoader loader) {
        if (loader instanceof EnhancingClassLoader) {
            EnhancingClassLoader enhancingLoader = (EnhancingClassLoader)loader;
            this._preloadLoader = enhancingLoader.getRawLoader();
        } else {
            this._preloadLoader = loader;
        }
        this._parentLoader = loader;
    }

    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public ClassLoader getParentLoader() {
        if (this._parentLoader == null) {
            this._parentLoader = Thread.currentThread().getContextClassLoader();
        }
        return this._parentLoader;
    }

    public ClassLoader getPreloadLoader() {
        if (this._preloadLoader == null) {
            this._preloadLoader = Thread.currentThread().getContextClassLoader();
            if (this._preloadLoader instanceof EnhancingClassLoader) {
                EnhancingClassLoader enhancingLoader = (EnhancingClassLoader)this._preloadLoader;
                this._preloadLoader = enhancingLoader.getRawLoader();
            }
        }
        return this._preloadLoader;
    }

    public void setWorkDir(Path workPath) {
        this._workPath = workPath;
    }

    public Path getWorkDir() {
        if (this._workPath == null) {
            return CauchoSystem.getWorkPath();
        }
        return this._workPath;
    }

    public Class preload(String fullClassName) {
        try {
            return this.loadClass(fullClassName, true);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(JavaClass javaClass) throws Exception {
        String className = javaClass.getFullClassName();
        String javaPathName = className.replace('.', '/') + ".java";
        String classPathName = className.replace('.', '/') + ".class";
        Path javaPath = this.getWorkDir().lookup(javaPathName);
        Path classPath = this.getWorkDir().lookup(classPathName);
        try {
            classPath.remove();
        }
        catch (IOException e) {
            // empty catch block
        }
        javaPath.getParent().mkdirs();
        WriteStream os = javaPath.openWrite();
        try {
            JavaWriter out = new JavaWriter(os);
            javaClass.generate(out);
        }
        finally {
            os.close();
        }
        this._pendingFiles.add(javaPathName);
    }

    public void addPendingFile(String javaPath) {
        this._pendingFiles.add(javaPath);
    }

    public Class compile(String fullClassName) throws Exception {
        this.compileJava(fullClassName);
        return this.loadClass(fullClassName, false);
    }

    public void compileJava(String fullClassName) throws IOException, ClassNotFoundException {
        JavaCompiler compiler = JavaCompiler.create(this.getPreloadLoader());
        compiler.setClassLoader(this.getPreloadLoader());
        compiler.setClassDir(this.getWorkDir());
        compiler.compile(fullClassName.replace('.', '/') + ".java", null);
    }

    public void compilePendingJava() throws IOException, ClassNotFoundException {
        JavaCompiler compiler = JavaCompiler.create(this.getPreloadLoader());
        compiler.setClassLoader(this.getPreloadLoader());
        compiler.setClassDir(this.getWorkDir());
        String[] files = new String[this._pendingFiles.size()];
        this._pendingFiles.toArray(files);
        this._pendingFiles.clear();
        compiler.compileBatch(files);
    }

    public Class loadClass(String fullClassName) throws ClassNotFoundException {
        return this.loadClass(fullClassName, false);
    }

    public Class loadClass(String fullClassName, boolean preload) throws ClassNotFoundException {
        try {
            ClassLoader loader;
            if (preload) {
                loader = SimpleLoader.create(this.getPreloadLoader(), this.getWorkDir(), fullClassName);
            } else {
                loader = this.getClassLoader();
                if (loader == null) {
                    loader = SimpleLoader.create(this.getParentLoader(), this.getWorkDir(), fullClassName);
                }
            }
            Class<?> cl = Class.forName(fullClassName, false, loader);
            if (cl == null) {
                return null;
            }
            if (!preload) {
                return cl;
            }
            if (this.isModified(cl)) {
                return null;
            }
            loader = this._loader != null ? this._loader : SimpleLoader.create(this.getParentLoader(), this.getWorkDir(), fullClassName);
            return Class.forName(fullClassName, false, loader);
        }
        catch (RuntimeException e) {
            if (!preload) {
                throw e;
            }
            return null;
        }
        catch (Error e) {
            if (!preload) {
                throw e;
            }
            return null;
        }
        catch (ClassNotFoundException e) {
            if (!preload) {
                throw e;
            }
            return null;
        }
    }

    public boolean isModified(Class cl) {
        Path searchPath = this.getSearchPath();
        if (searchPath == null) {
            searchPath = JavaClassGenerator.getDefaultSearchPath();
        }
        try {
            Method method = cl.getMethod(this._initMethod, ClassLiteral.getClass((String)"com/caucho/vfs/Path"));
            method.invoke(null, searchPath);
            method = cl.getMethod(this._isModifiedMethod, new Class[0]);
            Boolean value = (Boolean)method.invoke(null, new Object[0]);
            return value;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (Throwable e) {
            log.warning(e.toString());
            return true;
        }
    }
}

