/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.BaseMethod;
import com.caucho.java.gen.ClassComponent;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;

public class BaseClass
extends ClassComponent {
    private static L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/java/gen/BaseClass"));
    private String _className;
    private String _superClassName;
    private boolean _isStatic;
    private String _visibility = "public";
    private ArrayList<String> _interfaceNames = new ArrayList();
    private ArrayList<ClassComponent> _components = new ArrayList();
    private DependencyComponent _dependencyComponent;

    public BaseClass() {
    }

    public BaseClass(String className) {
        this._className = className;
    }

    public BaseClass(String className, String superClassName) {
        this._className = className;
        this._superClassName = superClassName;
    }

    public void setClassName(String className) {
        this._className = className;
    }

    public String getClassName() {
        return this._className;
    }

    public void setSuperClassName(String superClassName) {
        this._superClassName = superClassName;
    }

    public void addInterfaceName(String name) {
        this._interfaceNames.add(name);
    }

    public void setStatic(boolean isStatic) {
        this._isStatic = isStatic;
    }

    public void setVisibility(String visibility) {
        this._visibility = visibility;
    }

    public void addMethod(BaseMethod method) {
        this.addComponent(method);
    }

    public DependencyComponent addDependencyComponent() {
        if (this._dependencyComponent == null) {
            this._dependencyComponent = new DependencyComponent();
            this.addComponent(this._dependencyComponent);
        }
        return this._dependencyComponent;
    }

    public BaseMethod findMethod(Method method) {
        Iterator<ClassComponent> i$ = this._components.iterator();
        while (i$.hasNext()) {
            BaseMethod baseMethod;
            ClassComponent component = i$.next();
            if (!(component instanceof BaseMethod) || !(baseMethod = (BaseMethod)component).getMethod().equals(method)) continue;
            return baseMethod;
        }
        return null;
    }

    public BaseMethod createMethod(Method method) {
        BaseMethod baseMethod = this.findMethod(method);
        if (baseMethod == null) {
            baseMethod = new BaseMethod(method, method);
            this._components.add(baseMethod);
        }
        return baseMethod;
    }

    public void addComponent(ClassComponent component) {
        this._components.add(component);
    }

    public void generate(JavaWriter out) throws IOException {
        if (this._visibility != null && !this._visibility.equals("")) {
            out.print(this._visibility + " ");
        }
        if (this._isStatic) {
            out.print("static ");
        }
        out.print("class " + this._className);
        if (this._superClassName != null) {
            out.print(" extends " + this._superClassName);
        }
        if (this._interfaceNames.size() > 0) {
            out.print(" implements ");
            for (int i = 0; i < this._interfaceNames.size(); ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print(this._interfaceNames.get(i));
            }
        }
        out.println(" {");
        out.pushDepth();
        this.generateClassContent(out);
        out.popDepth();
        out.println("}");
    }

    protected void generateClassContent(JavaWriter out) throws IOException {
        this.generateComponents(out);
    }

    protected void generateComponents(JavaWriter out) throws IOException {
        for (int i = 0; i < this._components.size(); ++i) {
            if (i != 0) {
                out.println();
            }
            this._components.get(i).generate(out);
        }
    }
}

