/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.LineMap;
import com.caucho.util.IntMap;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.Iterator;

public class LineMapWriter {
    private WriteStream _os;

    public LineMapWriter(WriteStream os) {
        this._os = os;
    }

    public void write(LineMap lineMap) throws IOException {
        this._os.println("SMAP");
        this._os.println(lineMap.getDestFilename());
        this._os.println("JSP");
        this._os.println("*S JSP");
        IntMap fileMap = new IntMap();
        this._os.println("*F");
        Iterator<LineMap.Line> iter = lineMap.iterator();
        while (iter.hasNext()) {
            LineMap.Line line = iter.next();
            String filename = line.getSourceFilename();
            int index = fileMap.get(filename);
            if (index >= 0) continue;
            index = fileMap.size() + 1;
            fileMap.put(filename, index);
            if (filename.indexOf(47) >= 0) {
                int p = filename.lastIndexOf(47);
                this._os.println("+ " + index + " " + filename.substring(p + 1));
                if (filename.startsWith("/")) {
                    this._os.println(filename.substring(1));
                    continue;
                }
                this._os.println(filename);
                continue;
            }
            this._os.println(index + " " + filename);
        }
        this._os.println("*L");
        int size = lineMap.size();
        int lastIndex = 0;
        for (int i = 0; i < size; ++i) {
            LineMap.Line next;
            LineMap.Line line = lineMap.get(i);
            String filename = line.getSourceFilename();
            int index = fileMap.get(filename);
            String fileMarker = "";
            if (index != lastIndex) {
                fileMarker = "#" + index;
            }
            lastIndex = index;
            if (i + 1 < size && filename.equals((next = lineMap.get(i + 1)).getSourceFilename())) {
                if (line.getSourceLine() - next.getSourceLine() == line.getDestLine() - next.getDestLine()) {
                    this._os.println(line.getSourceLine() + fileMarker + "," + (next.getSourceLine() - line.getSourceLine() + 1) + ":" + line.getDestLine());
                    ++i;
                    continue;
                }
                if (line.getSourceLine() == next.getSourceLine()) {
                    this._os.println(line.getSourceLine() + fileMarker + ":" + line.getDestLine() + "," + (next.getDestLine() - line.getDestLine() + 1));
                    ++i;
                    continue;
                }
            }
            this._os.println(line.getSourceLine() + fileMarker + ":" + line.getDestLine());
        }
        this._os.println("*E");
    }
}

