/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.JavaCompiler;
import com.caucho.java.JavaWriter;
import com.caucho.java.gen.DependencyComponent;
import com.caucho.java.gen.JavaClass;
import com.caucho.loader.SimpleLoader;
import com.caucho.make.PersistentDependency;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerator {
    private String _fullClassName;
    private String _packageName;
    private String _className;
    private ClassLoader _parentLoader;
    private ClassLoader _loader;
    private WriteStream _os;
    protected JavaWriter _out;
    private Path _searchPath;
    private Path _workPath;
    private JavaClass _javaClass;
    private String _initMethod = "_caucho_init";
    private String _isModifiedMethod = "_caucho_is_modified";

    public void setSearchPath(Path path) {
        this._searchPath = path;
    }

    public Path getSearchPath() {
        return this._searchPath;
    }

    public void setFullClassName(String fullClassName) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < fullClassName.length(); ++i) {
            char ch = fullClassName.charAt(i);
            if (ch == '.' || ch == '/') {
                cb.append('.');
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                cb.append(ch);
                continue;
            }
            cb.append('_');
        }
        this._fullClassName = cb.close();
        int p = this._fullClassName.lastIndexOf(46);
        if (p > 0) {
            this._packageName = this._fullClassName.substring(0, p);
            this._className = this._fullClassName.substring(p + 1);
        } else {
            this._packageName = "";
            this._className = this._fullClassName;
        }
    }

    public String getFullClassName() {
        if (this._javaClass != null) {
            return this._javaClass.getFullClassName();
        }
        return this._fullClassName;
    }

    public String getPackageName() {
        if (this._javaClass != null) {
            return this._javaClass.getPackageName();
        }
        return this._packageName;
    }

    public String getClassName() {
        if (this._javaClass != null) {
            return this._javaClass.getClassName();
        }
        return this._className;
    }

    public void setJavaClass(JavaClass javaClass) {
        this._javaClass = javaClass;
    }

    public JavaClass getJavaClass() {
        return this._javaClass;
    }

    public void setParentLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public ClassLoader getParentLoader() {
        if (this._parentLoader == null) {
            this._parentLoader = Thread.currentThread().getContextClassLoader();
        }
        return this._parentLoader;
    }

    public void setClassDir(Path workPath) {
        this._workPath = workPath;
    }

    public Path getClassDir() {
        if (this._workPath == null) {
            return CauchoSystem.getWorkPath();
        }
        return this._workPath;
    }

    public Class preload() throws IOException {
        return this.loadClass(true);
    }

    public void generate() throws Exception {
        String className = this.getFullClassName();
        String javaPathName = new StringBuffer().append(className.replace('.', '/')).append(".java").toString();
        String classPathName = new StringBuffer().append(className.replace('.', '/')).append(".class").toString();
        Path javaPath = this.getClassDir().lookup(javaPathName);
        Path classPath = this.getClassDir().lookup(classPathName);
        try {
            classPath.remove();
        }
        catch (IOException e) {
            // empty catch block
        }
        javaPath.getParent().mkdirs();
        this._os = javaPath.openWrite();
        this._out = new JavaWriter(this._os);
        if (this._javaClass != null) {
            this._javaClass.generate(this._out);
        } else {
            this.generateJava();
        }
        this._os.close();
    }

    public Class compile() throws Exception {
        this.compileJava();
        return this.loadClass(false);
    }

    public void generateJava() throws Exception {
    }

    protected void printDependList(ArrayList<PersistentDependency> depends) throws IOException {
        DependencyComponent depend = new DependencyComponent();
        depend.setSearchPath(this._searchPath);
        for (int i = 0; i < depends.size(); ++i) {
            depend.addDependency(depends.get(i));
        }
        depend.generate(this.getOut());
    }

    protected void printVersionChange() throws IOException {
        this.println(new StringBuffer().append("if (com.caucho.util.CauchoSystem.getVersionId() != ").append(CauchoSystem.getVersionId()).append(")").toString());
        this.println("  return true;");
    }

    public void printMethodHeader(Method method) throws IOException {
        this.printMethodHeader(method.getName(), method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes());
    }

    public void printMethodHeader(String name, Method method) throws IOException {
        this.printMethodHeader(name, method.getParameterTypes(), method.getReturnType(), method.getExceptionTypes());
    }

    public void printMethodHeader(String methodName, Class[] parameters, Class returnType, Class[] exn) throws IOException {
        int i;
        this.println();
        this.print("public ");
        this.printClass(returnType);
        this.print(" ");
        this.print(methodName);
        this.print("(");
        for (i = 0; i < parameters.length; ++i) {
            if (i != 0) {
                this.print(", ");
            }
            this.printClass(parameters[i]);
            this.print(new StringBuffer().append(" a").append(i).toString());
        }
        this.println(")");
        if (exn != null && exn.length > 0) {
            this.print("  throws ");
            this.printClass(exn[0]);
            for (i = 1; i < exn.length; ++i) {
                this.print(", ");
                this.printClass(exn[i]);
            }
            this.println();
        }
    }

    public void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName());
        } else {
            this.printClass(cl.getComponentType());
            this.print("[]");
        }
    }

    public void compileJava() throws IOException, ClassNotFoundException {
        JavaCompiler compiler = this.getCompiler();
        compiler.compile(new StringBuffer().append(this.getFullClassName().replace('.', '/')).append(".java").toString(), null);
    }

    public JavaCompiler getCompiler() {
        JavaCompiler compiler = JavaCompiler.create(this.getParentLoader());
        compiler.setClassLoader(this.getParentLoader());
        compiler.setClassDir(this.getClassDir());
        return compiler;
    }

    public Class loadClass(boolean preload) throws IOException {
        return this.loadClass(this.getFullClassName(), preload);
    }

    public Class loadClass(String fullClassName, boolean preload) throws IOException {
        try {
            ClassLoader loader = !preload && this._loader != null ? this._loader : SimpleLoader.create(this.getParentLoader(), this.getClassDir(), fullClassName);
            Class cl = CauchoSystem.loadClass(fullClassName, false, loader);
            if (cl == null) {
                return null;
            }
            if (!preload) {
                return cl;
            }
            Method method = cl.getMethod(this._initMethod, ClassLiteral.getClass((String)"com/caucho/vfs/Path"));
            method.invoke(null, this.getSearchPath());
            method = cl.getMethod(this._isModifiedMethod, new Class[0]);
            Boolean value = (Boolean)method.invoke(null, new Object[0]);
            if (value.booleanValue()) {
                return null;
            }
            loader = this._loader != null ? this._loader : SimpleLoader.create(this.getParentLoader(), this.getClassDir(), fullClassName);
            return CauchoSystem.loadClass(fullClassName, false, loader);
        }
        catch (Throwable e) {
            if (!preload) {
                throw new IOExceptionWrapper(e);
            }
            return null;
        }
    }

    public JavaWriter getOut() {
        return this._out;
    }

    public void pushDepth() throws IOException {
        this._out.pushDepth();
    }

    public void popDepth() throws IOException {
        this._out.popDepth();
    }

    public void print(int ch) throws IOException {
        this._out.print(ch);
    }

    public void print(char ch) throws IOException {
        this._out.print(ch);
    }

    public void print(String s) throws IOException {
        this._out.print(s);
    }

    public void printStr(String s) throws IOException {
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    this._out.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    this._out.print("\\n");
                    continue block6;
                }
                case '\r': {
                    this._out.print("\\r");
                    continue block6;
                }
                case '\"': {
                    this._out.print("\\\"");
                    continue block6;
                }
                default: {
                    this._out.print(ch);
                }
            }
        }
    }

    public void println() throws IOException {
        this._out.println();
    }

    public void println(String s) throws IOException {
        this._out.println(s);
    }
}

