/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.java.AbstractGenerator;
import com.caucho.util.CauchoSystem;
import com.caucho.vfs.MergePath;
import com.caucho.vfs.Path;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.lang.reflect.Method;

public class IiopStubCompiler
extends AbstractGenerator {
    private Class _cl;

    public IiopStubCompiler(Class cl) {
        this._cl = cl;
        String name = cl.getName();
        int p = name.lastIndexOf(46);
        if (p > 0) {
            String pkg = name.substring(0, p);
            String tail = name.substring(p + 1);
            this.setFullClassName(pkg + "._" + tail + "_Stub");
        } else {
            this.setFullClassName("_" + name + "_Stub");
        }
    }

    public void generateJava() throws Exception {
        this.printHeader();
        Method[] methods = this._cl.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBHome")) || method.getDeclaringClass().isAssignableFrom(ClassLiteral.getClass((String)"javax/ejb/EJBObject"))) continue;
            this.printMethod(method);
        }
        this.printFooter();
    }

    private void printHeader() throws IOException {
        this.println("/*");
        this.println(" * Generated by Resin-EJB IiopStubCompiler");
        this.println(" */");
        this.println();
        if (this.getPackageName() != null) {
            this.println("package " + this.getPackageName() + ";");
        }
        this.println();
        this.print("public class " + this.getClassName());
        if (ClassLiteral.getClass((String)"javax/ejb/EJBHome").isAssignableFrom(this._cl)) {
            this.println(" extends com.caucho.iiop.client.IiopHomeStub");
        } else {
            this.println(" extends com.caucho.iiop.client.IiopStub");
        }
        this.println("  implements " + this._cl.getName() + " {");
        this.pushDepth();
        this.println("private static final String[] _type_ids = {");
        this.println("  \"RMI:" + this._cl.getName() + ":0000000000000000\"");
        this.println("};");
        this.println();
        this.println("public String[] _ids()");
        this.println("{");
        this.println("  return _type_ids;");
        this.println("}");
    }

    private void printMethod(Method method) throws IOException {
        this.printMethodHeader(method);
        this.println("{");
        this.pushDepth();
        this.println("org.omg.CORBA_2_3.portable.OutputStream os = null;");
        this.println("try {");
        this.pushDepth();
        this.println("os = (org.omg.CORBA_2_3.portable.OutputStream) _request(\"" + method.getName() + "\", true);");
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            this.printSetValue(args[i], "a" + i);
        }
        this.println("org.omg.CORBA_2_3.portable.InputStream is;");
        this.println("is = (org.omg.CORBA_2_3.portable.InputStream) _invoke(os);");
        Class<?> returnType = method.getReturnType();
        if (!returnType.equals(Void.TYPE)) {
            this.print("return ");
            this.printGetValue(returnType);
            this.println(";");
        }
        this.popDepth();
        this.println("} catch (Exception e) {");
        this.println("  e.printStackTrace();");
        this.println("  throw new RuntimeException(e);");
        this.println("}");
        this.popDepth();
        this.println("}");
    }

    private void printGetValue(Class type) throws IOException {
        if (type.equals(Boolean.TYPE)) {
            this.print("is.read_boolean()");
        } else if (type.equals(Byte.TYPE)) {
            this.print("is.read_octet()");
        } else if (type.equals(Short.TYPE)) {
            this.print("is.read_short()");
        } else if (type.equals(Integer.TYPE)) {
            this.print("is.read_long()");
        } else if (type.equals(Long.TYPE)) {
            this.print("is.read_longlong()");
        } else if (type.equals(Float.TYPE)) {
            this.print("is.read_float()");
        } else if (type.equals(Double.TYPE)) {
            this.print("is.read_double()");
        } else if (type.equals(Character.TYPE)) {
            this.print("is.read_wchar()");
        } else if (ClassLiteral.getClass((String)"javax/ejb/EJBObject").isAssignableFrom(type) || ClassLiteral.getClass((String)"java/rmi/Remote").isAssignableFrom(type)) {
            this.print("(" + type.getName() + ") is.read_abstract_interface(" + type.getName() + ".class)");
        } else {
            this.print("(" + type.getName() + ") is.read_value(" + type.getName() + ".class)");
        }
    }

    private void printSetValue(Class type, String value) throws IOException {
        if (type.equals(Boolean.TYPE)) {
            this.println("os.write_boolean(" + value + ");");
        } else if (type.equals(Byte.TYPE)) {
            this.println("os.write_octet(" + value + ");");
        } else if (type.equals(Short.TYPE)) {
            this.println("os.write_short(" + value + ");");
        } else if (type.equals(Integer.TYPE)) {
            this.println("os.write_long(" + value + ");");
        } else if (type.equals(Long.TYPE)) {
            this.println("os.write_longlong(" + value + ");");
        } else if (type.equals(Float.TYPE)) {
            this.println("os.write_float(" + value + ");");
        } else if (type.equals(Double.TYPE)) {
            this.println("os.write_double(" + value + ");");
        } else if (type.equals(Character.TYPE)) {
            this.println("os.write_wchar(" + value + ");");
        } else {
            this.println("os.write_value((java.io.Serializable) " + value + ");");
        }
    }

    private void printFooter() throws IOException {
        this.popDepth();
        this.println("}");
    }

    public static Class create(String className) throws Exception {
        Class cl = CauchoSystem.loadClass(className);
        MergePath mergePath = new MergePath();
        mergePath.addClassPath();
        Path classPath = mergePath.lookup(className.replace('.', '/') + ".class");
        classPath = ((MergePath)classPath).getBestPath();
        Path dir = classPath.getParent();
        int i = 0;
        while ((i = className.indexOf(46, i + 1)) >= 0) {
            dir = dir.getParent();
        }
        dir.mkdirs();
        IiopStubCompiler compiler = new IiopStubCompiler(cl);
        compiler.setClassDir(dir);
        Class gen = compiler.preload();
        if (gen != null) {
            return gen;
        }
        compiler.generate();
        return compiler.compile();
    }

    public static void main(String[] argv) throws Exception {
        String className = argv[0];
        System.out.println(IiopStubCompiler.create(className));
    }
}

