/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.AnyImpl;
import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.TypeCodeImpl;
import com.caucho.log.Log;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.IntArray;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.SendingContext.RunTime;

public class IiopReader
extends InputStream {
    protected static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/iiop/IiopReader"));
    protected static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/iiop/IiopReader"));
    public static final int MSG_REQUEST = 0;
    public static final int MSG_REPLY = 1;
    public static final int MSG_CANCEL_REQUEST = 2;
    public static final int MSG_LOCATE_REQUEST = 3;
    public static final int MSG_LOCATE_REPLY = 4;
    public static final int MSG_CLOSE_CONNECTION = 5;
    public static final int MSG_ERROR = 6;
    public static final int MSG_FRAGMENT = 7;
    public static final int SERVICE_TRANSACTION = 0;
    public static final int SERVICE_CODE_SET = 1;
    public static final int SERVICE_CHAIN_BYPASS_CHECK = 2;
    public static final int SERVICE_CHAIN_BYPASS_INFO = 3;
    public static final int SERVICE_LOGICAL_THREAD_ID = 4;
    public static final int SERVICE_BI_DIR_IIOP = 5;
    public static final int SERVICE_SENDING_CONTEXT_RUN_TIME = 6;
    public static final int SERVICE_INVOCATION_POLICIES = 7;
    public static final int SERVICE_FORWARDED_IDENTITY = 8;
    public static final int SERVICE_UNKNOWN_EXCEPTION_INFO = 9;
    public static final int STATUS_NO_EXCEPTION = 0;
    public static final int STATUS_USER_EXCEPTION = 1;
    public static final int STATUS_SYSTEM_EXCEPTION = 2;
    public static final int STATUS_LOCATION_FORWARD = 3;
    private ReadStream _rs;
    private byte[] _header = new byte[8];
    private byte[] buf = new byte[16];
    private IntArray _refOffsets = new IntArray();
    private ArrayList<Serializable> _refValues = new ArrayList();
    private CharBuffer cb = new CharBuffer();
    private int _major;
    private int _minor;
    private boolean _isBigEndian;
    private boolean _hasMoreFragments;
    private int _flags;
    private int _offset;
    private int _length;
    private int _type;
    private int _fragmentOffset;
    private int _chunkEnd = -1;
    private int _chunkDepth = 0;
    private int requestId;
    private boolean responseExpected;
    private ByteBuffer objectKey = new ByteBuffer();
    private CharBuffer _operation = new CharBuffer();
    private ByteBuffer principal = new ByteBuffer();
    private ValueHandler _valueHandler = Util.createValueHandler();
    private RunTime runTime = this._valueHandler.getRunTimeCodeBase();

    public IiopReader() {
    }

    public IiopReader(ReadStream rs) {
        this.init(rs);
    }

    public void init(ReadStream rs) {
        this._rs = rs;
        this._major = 0;
        this._minor = 0;
        this._type = 0;
        this.requestId = 0;
        this.objectKey.clear();
        this._operation.clear();
        this._offset = 0;
        this._length = 0;
        this._fragmentOffset = 0;
        this._refValues.clear();
        this._refOffsets.clear();
    }

    public int getMajorVersion() {
        return this._major;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getRequestType() {
        return this._type;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public boolean isBigEndian() {
        return this._isBigEndian;
    }

    public int getOffset() {
        return this._offset;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public ByteBuffer getObjectKey() {
        return this.objectKey;
    }

    public CharBuffer getOperation() {
        return this._operation;
    }

    public void readRequest() throws IOException {
        block18: {
            block20: {
                block19: {
                    block17: {
                        int len = this._rs.readAll(this._header, 0, this._header.length);
                        if (this._header[0] != 71 || this._header[1] != 73 || this._header[2] != 79 || this._header[3] != 80) {
                            throw new IOException(L.l("unknown request {0}, {1}, {2}, {3}", "" + this.toCh(this._header[0]), "" + this.toCh(this._header[1]), "" + this.toCh(this._header[2]), "" + this.toCh(this._header[3])));
                        }
                        this._major = this._header[4];
                        this._minor = this._header[5];
                        if (this._major != 1) {
                            throw new IOException("unknown major");
                        }
                        this._flags = this._header[6];
                        this._isBigEndian = (this._flags & 1) == 0;
                        this._hasMoreFragments = (this._flags & 2) == 2;
                        this._type = this._header[7];
                        this._length = this.readIntRaw() + 4;
                        this._offset = 4;
                        if (this._minor != 0) break block17;
                        switch (this._type) {
                            case 0: {
                                this.readRequest10();
                                break block18;
                            }
                            case 1: {
                                this.readReply10();
                                break block18;
                            }
                            case 6: {
                                throw new RuntimeException("MSG_ERROR: unknown protocol error");
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    if (this._minor != 1) break block19;
                    switch (this._type) {
                        case 0: {
                            this.readRequest10();
                            break block18;
                        }
                        case 1: {
                            this.readReply10();
                            break block18;
                        }
                        case 6: {
                            throw new RuntimeException("MSG_ERROR: unknown protocol error");
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (this._minor != 2) break block20;
                switch (this._type) {
                    case 0: {
                        this.readRequest12();
                        break block18;
                    }
                    case 1: {
                        this.readReply10();
                        break block18;
                    }
                    case 6: {
                        throw new RuntimeException("MSG_ERROR: unknown protocol error");
                    }
                    default: {
                        throw new RuntimeException("unknown type: " + this._type);
                    }
                }
            }
            throw new IOException("unknown minor");
        }
    }

    private void readRequest10() throws IOException {
        this.readServiceContextList();
        this.requestId = this.readInt();
        this.responseExpected = this.read_octet() != 0;
        this.readOctetSequence(this.objectKey);
        this.readString(this._operation);
        this.readOctetSequence(this.principal);
    }

    private void readReply10() throws IOException {
        this.readServiceContextList();
        int requestId = this.readInt();
        int status = this.readInt();
        switch (status) {
            case 0: {
                return;
            }
            case 2: {
                String exceptionId = this.readString();
                int minorStatus = this.readInt();
                int completionStatus = this.readInt();
                throw new IOException("exception: " + exceptionId);
            }
            case 1: {
                java.lang.Object value = this.read_fault();
                throw new IOException("user exception: " + value);
            }
        }
        throw new IOException("unknown status: " + status);
    }

    private void readRequest12() throws IOException {
        this.requestId = this.readInt();
        byte flags = this.read_octet();
        this.responseExpected = flags != 0;
        int disposition = this.read_long();
        this.readOctetSequence(this.objectKey);
        this.readString(this._operation);
        this.readServiceContextList();
        int frag = this._offset % 8;
        if (frag > 0 && frag < 8) {
            int delta = 8 - frag;
            if (this._length < this._offset + delta) {
                delta = this._length - this._offset;
            }
            if (delta > 0) {
                this._offset += delta;
                this._rs.skip(delta);
            }
        }
    }

    private void readServiceContextList() throws IOException {
        int length = this.readInt();
        for (int i = 0; i < length; ++i) {
            int serviceId = this.readInt();
            int dataLength = this.readInt();
            if (serviceId == 1) {
                byte endian = this.read_octet();
                int charSet = this.readInt();
                int wcharSet = this.readInt();
                continue;
            }
            this.skip(dataLength);
        }
    }

    private void debugTail() throws IOException {
        int len = this._length;
        for (int i = 0; i < len; i += 8) {
            int j;
            int sublen = this._rs.read(this.buf, 0, 16);
            for (j = 0; j < 16; ++j) {
                if (j < sublen) {
                    this.printHex(this.buf[j]);
                } else {
                    System.out.print("  ");
                }
                if (j == 7) {
                    System.out.print(" - ");
                    continue;
                }
                System.out.print(" ");
            }
            for (j = 0; j < 16; ++j) {
                int ch = this.buf[j] & 0xFF;
                if (j >= sublen) {
                    System.out.print("?");
                    continue;
                }
                if (ch >= 32 && ch < 128) {
                    System.out.print((char)ch);
                    continue;
                }
                System.out.print("?");
            }
            System.out.println();
        }
        System.out.println();
    }

    public IOR readIOR() throws IOException {
        IOR ior = new IOR();
        return ior.read(this);
    }

    public java.lang.Object readObject(Class cl) throws IOException {
        IOR ior = this.readIOR();
        return null;
    }

    public String readWideString() throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        for (int len = this.readInt(); len > 0; --len) {
            cb.append((char)this.read_short());
        }
        return cb.close();
    }

    public Serializable read_value() {
        return this.read_value(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable read_value(Class type) {
        String string;
        block28: {
            block29: {
                int delta;
                int oldChunkEnd = this._chunkEnd;
                this.align4();
                int startOffset = this._offset - this._fragmentOffset;
                this._chunkEnd = -1;
                int code = this.read_long();
                String repId = "";
                boolean isChunked = false;
                if (code == 0) {
                    return null;
                }
                if (code == -1) {
                    this._chunkEnd = oldChunkEnd;
                    int start = this._offset - this._fragmentOffset;
                    int delta2 = this.read_long();
                    int target = start + delta2;
                    for (int i = 0; i < this._refOffsets.size(); ++i) {
                        int refOffset = this._refOffsets.get(i);
                        if (refOffset != target) continue;
                        return this._refValues.get(i);
                    }
                    throw new RuntimeException();
                }
                if ((code & 0x7FFFFF00) != 0x7FFFFF00) {
                    repId = this.readString(code);
                } else {
                    isChunked = (code & 8) == 8;
                    boolean hasCodeBase = (code & 1) == 1;
                    int repository = code & 6;
                    if (hasCodeBase) {
                        this.readCodeBase();
                    }
                    if (repository == 2) {
                        repId = this.read_string();
                    } else {
                        throw new RuntimeException("Can't cope with repository=" + repository);
                    }
                }
                try {
                    if (isChunked) {
                        int chunkLength = this.readInt();
                        this._chunkEnd = chunkLength + this._offset;
                        ++this._chunkDepth;
                    }
                    java.lang.Object value = null;
                    if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                        value = this.read_wstring();
                    } else if (!repId.startsWith("RMI:") && !repId.startsWith("IDL:")) {
                        log.warning("unknown rep: " + repId + " " + code);
                        Thread.dumpStack();
                        value = repId;
                    } else {
                        int p = repId.indexOf(58, 4);
                        if (p < 0) {
                            throw new RuntimeException("unknown RMI: " + repId);
                        }
                        String className = repId.substring(4, p);
                        if (className.equals("javax.rmi.CORBA.ClassDesc")) {
                            value = this.readClass();
                        } else {
                            Class cl = null;
                            try {
                                cl = CauchoSystem.loadClass(className);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                            value = this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, this._offset, cl, repId, this.runTime);
                        }
                    }
                    if (value != null) {
                        this._refOffsets.add(startOffset);
                        this._refValues.add((Serializable)value);
                    }
                    string = value;
                    if (this._chunkDepth <= 0) break block28;
                    --this._chunkDepth;
                    delta = this._chunkEnd - this.getOffset();
                    this._chunkEnd = -1;
                    if (delta <= 0) break block29;
                }
                catch (Throwable throwable) {
                    try {
                        if (this._chunkDepth > 0) {
                            --this._chunkDepth;
                            int delta3 = this._chunkEnd - this.getOffset();
                            this._chunkEnd = -1;
                            if (delta3 > 0) {
                                this.skip(delta3);
                            }
                            if (this._chunkDepth > 0) {
                                int newChunk = this.readInt();
                                this._chunkEnd = this._offset;
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.skip(delta);
            }
            if (this._chunkDepth > 0) {
                int newChunk = this.readInt();
                this._chunkEnd = this._offset;
            }
        }
        return string;
    }

    private Class readClass() throws IOException {
        String codebase = (String)((java.lang.Object)this.read_value(ClassLiteral.getClass((String)"java/lang/String")));
        String repId = (String)((java.lang.Object)this.read_value(ClassLiteral.getClass((String)"java/lang/String")));
        if (codebase.startsWith("RMI:")) {
            String temp = repId;
            repId = codebase;
            codebase = temp;
        }
        return this.loadClass(repId);
    }

    private Class loadClass(String repId) throws RuntimeException {
        if (!repId.startsWith("RMI:")) {
            throw new RuntimeException("unknown RMI: " + repId);
        }
        int p = repId.indexOf(58, 4);
        if (p < 0) {
            throw new RuntimeException("unknown RMI: " + repId);
        }
        String className = repId.substring(4, p);
        java.lang.Object cl = null;
        try {
            Thread thread = Thread.currentThread();
            return Class.forName(className, false, thread.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String readCodeBase() {
        String codeBase = this.read_string();
        return codeBase;
    }

    public java.lang.Object read_fault() {
        int startOffset = this._offset;
        int originalOffset = this._rs.getOffset();
        String repId = this.read_string();
        if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            return this.read_wstring();
        }
        Class cl = null;
        if (repId.startsWith("RMI:")) {
            int p = repId.indexOf(58, 4);
            if (p < 0) {
                throw new RuntimeException("unknown RMI: " + repId);
            }
            String className = repId.substring(4, p);
            try {
                cl = CauchoSystem.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, this._offset, cl, repId, this.runTime);
        }
        String className = null;
        if (repId.startsWith("IDL:")) {
            String tail = repId.substring(4);
            int p = tail.indexOf(58);
            if (p > 0) {
                tail = tail.substring(0, p);
            }
            if (tail.startsWith("omg.org/")) {
                tail = "org.omg." + tail.substring("omg.org/".length());
            }
            className = tail.replace('/', '.');
        } else {
            className = repId;
        }
        String handler = className + "Handler";
        Class handlerClass = null;
        try {
            cl = CauchoSystem.loadClass(className);
            handlerClass = CauchoSystem.loadClass(handler);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            int p = className.lastIndexOf(46);
            className = className.substring(0, p) + "Package" + className.substring(p);
            handler = className + "Helper";
            try {
                cl = CauchoSystem.loadClass(className);
                handlerClass = CauchoSystem.loadClass(handler);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl != null && handlerClass != null) {
            Method readHelper = null;
            try {
                readHelper = handlerClass.getMethod("read", ClassLiteral.getClass((String)"org/omg/CORBA/portable/InputStream"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (readHelper != null) {
                try {
                    this._offset = startOffset;
                    this._rs.setOffset(originalOffset);
                    return readHelper.invoke(null, new java.lang.Object[]{this});
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.valueOf(e));
                }
            }
        }
        return new IOException("unknown fault: " + repId);
    }

    public boolean read_boolean() {
        try {
            return this.read() != 0;
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public char read_char() {
        try {
            return (char)this.read();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public char read_wchar() {
        return (char)this.read_short();
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        try {
            return this.readInt();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        try {
            return this.readLong();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public byte read_octet() {
        try {
            return (byte)this.read();
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public float read_float() {
        int v = this.read_long();
        return Float.intBitsToFloat(v);
    }

    public double read_double() {
        long v = this.read_longlong();
        return Double.longBitsToDouble(v);
    }

    public void read_boolean_array(boolean[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_boolean();
        }
    }

    public void read_char_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_char();
        }
    }

    public String read_string() {
        CharBuffer cb = CharBuffer.allocate();
        int len = this.read_long();
        for (int i = 0; i < len - 1; ++i) {
            cb.append(this.read_char());
        }
        this.read_octet();
        return cb.close();
    }

    public String readString(int len) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < len - 1; ++i) {
            cb.append(this.read_char());
        }
        this.read_octet();
        return cb.close();
    }

    public void read_wchar_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_wchar();
        }
    }

    public String read_wstring() {
        return this.read_wstring(this.read_long());
    }

    public String read_wstring(int len) {
        CharBuffer cb = CharBuffer.allocate();
        if (this._minor == 2) {
            while (len > 1) {
                char ch = this.read_wchar();
                cb.append(ch);
                len -= 2;
            }
            if (len > 0) {
                this.read_octet();
            }
        } else {
            for (int i = 0; i < len - 1; ++i) {
                char ch = this.read_wchar();
                cb.append(ch);
            }
            this.read_wchar();
        }
        return cb.close();
    }

    public void read_octet_array(byte[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_octet();
        }
    }

    public void read_short_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_short();
        }
    }

    public void read_ushort_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ushort();
        }
    }

    public void read_long_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_long();
        }
    }

    public void read_ulong_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulong();
        }
    }

    public void read_longlong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulonglong();
        }
    }

    public void read_float_array(float[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_float();
        }
    }

    public void read_double_array(double[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_double();
        }
    }

    public java.lang.Object read_abstract_interface() {
        boolean discriminator = this.read_boolean();
        if (discriminator) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public Object read_Object() {
        try {
            return new DummyObjectImpl(this.readIOR());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeCode read_TypeCode() {
        try {
            return TypeCodeImpl.read(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Any read_any() {
        try {
            TypeCode typeCode = this.read_TypeCode();
            AnyImpl any = new AnyImpl();
            any.read_value((org.omg.CORBA.portable.InputStream)this, typeCode);
            return any;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Principal read_Principal() {
        throw new UnsupportedOperationException();
    }

    public int read_sequence_length() {
        int length = this.read_long();
        if (length < 0 || length > 65536) {
            throw new RuntimeException("sequence too long:" + length);
        }
        return length;
    }

    public void readOctetSequence(ByteBuffer bb) throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        bb.ensureCapacity(len);
        this._offset += len;
        this._rs.readAll(bb.getBuffer(), 0, len);
        bb.setLength(len);
    }

    public byte[] readBytes() throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        this._offset += len;
        byte[] buf = new byte[len];
        this._rs.readAll(buf, 0, len);
        return buf;
    }

    public void readBytes(byte[] buf, int off, int len) throws IOException {
        this._offset += len;
        this._rs.readAll(buf, off, len);
    }

    public String readString() throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        CharBuffer cb = CharBuffer.allocate();
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            byte ch = this.read_octet();
            cb.append((char)ch);
        }
        byte ch = this.read_octet();
        return cb.close();
    }

    public void readString(CharBuffer cb) throws IOException {
        int len = this.readInt();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            int ch = this.read();
            cb.append((char)ch);
        }
        int n = this.read();
    }

    public short read_short() {
        try {
            if ((this._offset & 1) == 1) {
                this.read();
            }
            if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
                this.handleFragment();
            }
            int ch1 = this.read();
            int ch2 = this.read();
            if (ch2 < 0) {
                throw new EOFException();
            }
            return (short)(((ch1 & 0xFF) << 8) + (ch2 & 0xFF));
        }
        catch (IOException e) {
            throw new RuntimeException(String.valueOf(e));
        }
    }

    public int readInt() throws IOException {
        this.align4();
        if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
            this.handleFragment();
        }
        this._offset += 4;
        return this.readIntRaw();
    }

    private int readIntRaw() throws IOException {
        int ch1 = this._rs.read();
        int ch2 = this._rs.read();
        int ch3 = this._rs.read();
        int ch4 = this._rs.read();
        if (ch4 < 0) {
            throw new EOFException();
        }
        return ((ch1 & 0xFF) << 24) + ((ch2 & 0xFF) << 16) + ((ch3 & 0xFF) << 8) + (ch4 & 0xFF);
    }

    public long readLong() throws IOException {
        this.align8();
        if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
            this.handleFragment();
        }
        this._offset += 8;
        int ch1 = this._rs.read();
        int ch2 = this._rs.read();
        int ch3 = this._rs.read();
        int ch4 = this._rs.read();
        int ch5 = this._rs.read();
        int ch6 = this._rs.read();
        int ch7 = this._rs.read();
        int ch8 = this._rs.read();
        if (ch8 < 0) {
            throw new EOFException();
        }
        return (((long)ch1 & 0xFFL) << 56) + (((long)ch2 & 0xFFL) << 48) + (((long)ch3 & 0xFFL) << 40) + (((long)ch4 & 0xFFL) << 32) + (((long)ch5 & 0xFFL) << 24) + (((long)ch6 & 0xFFL) << 16) + (((long)ch7 & 0xFFL) << 8) + ((long)ch8 & 0xFFL);
    }

    private void align4() throws IOException {
        int frag = this._offset % 4;
        if (frag > 0 && frag < 4) {
            this._offset += 4 - frag;
            this._rs.skip(4 - frag);
        }
    }

    private void align8() throws IOException {
        int frag = this._offset % 8;
        if (frag > 0 && frag < 8) {
            this._offset += 8 - frag;
            this._rs.skip(8 - frag);
        }
    }

    public int read() throws IOException {
        if (this._length <= this._offset && this._hasMoreFragments || this._offset == this._chunkEnd) {
            this.handleFragment();
        }
        ++this._offset;
        return this._rs.read();
    }

    public void completeRead() throws IOException {
        while (this._offset < this._length) {
            ++this._offset;
            this._rs.read();
        }
    }

    private void handleFragment() throws IOException {
        if (this._length < this._offset) {
            throw new IllegalStateException(L.l("Read {0} past length {1}", (java.lang.Object)("" + this._offset), "" + this._length));
        }
        if (this._length <= this._offset) {
            while (this._offset % 8 != 0) {
                ++this._offset;
                ++this._length;
                if (this._chunkEnd > 0) {
                    ++this._chunkEnd;
                }
                int ch = this._rs.read();
            }
            int len = this._rs.readAll(this._header, 0, this._header.length);
            if (len != this._header.length) {
                throw new EOFException("Unexpected length: " + len);
            }
            if (this._header[0] != 71 || this._header[1] != 73 || this._header[2] != 79 || this._header[3] != 80) {
                throw new IOException(L.l("unknown request {0},{1},{2},{3}", "" + this._header[0], "" + this._header[1], "" + this._header[2], "" + this._header[3]));
            }
            this._major = this._header[4];
            this._minor = this._header[5];
            if (this._major != 1) {
                throw new IOException("unknown major");
            }
            this._flags = this._header[6];
            this._isBigEndian = (this._flags & 1) == 0;
            this._hasMoreFragments = (this._flags & 2) == 2;
            this._type = this._header[7];
            this._fragmentOffset += 8;
            this._offset += 4;
            this._length += 4;
            if (this._chunkEnd > 0) {
                this._chunkEnd += 4;
            }
            int fragLen = this.readIntRaw();
            this._length += fragLen;
            if (this._type != 7) {
                throw new IOException(L.l("expected Fragment at {0}", "" + this._type));
            }
            if (this._minor == 2) {
                if (this._chunkEnd > 0) {
                    this._chunkEnd += 4;
                }
                int n = this.readInt();
            }
        }
        if (this._offset == this._chunkEnd) {
            while (this._offset % 4 != 0) {
                ++this._offset;
                this._rs.read();
            }
            if (this._length <= this._offset) {
                this.handleFragment();
                return;
            }
            this._offset += 4;
            int chunkLength = this.readIntRaw();
            this._chunkEnd = this.getOffset() + chunkLength;
        }
    }

    private void skip(int len) throws IOException {
        if (this._length <= this._offset && this._hasMoreFragments) {
            this.handleFragment();
        }
        this._offset += len;
        this._rs.skip(len);
    }

    private void writeHexGroup(int count) {
        try {
            this.align4();
            byte[] v = new byte[16];
            for (int i = 0; i < count; ++i) {
                int j;
                this._rs.readAll(v, 0, v.length);
                for (j = 0; j < v.length; ++j) {
                    System.out.print(" ");
                    this.printHex(v[j]);
                }
                System.out.print(" ");
                for (j = 0; j < v.length; ++j) {
                    this.printCh(v[j]);
                }
                System.out.println();
            }
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }

    private void printHex(int d) {
        int ch1 = d >> 4 & 0xF;
        int ch2 = d & 0xF;
        if (ch1 >= 10) {
            System.out.print((char)(97 + ch1 - 10));
        } else {
            System.out.print((char)(48 + ch1));
        }
        if (ch2 >= 10) {
            System.out.print((char)(97 + ch2 - 10));
        } else {
            System.out.print((char)(48 + ch2));
        }
    }

    private void printCh(int d) {
        if (d >= 32 && d <= 127) {
            System.out.print("" + (char)d);
        } else {
            System.out.print(".");
        }
    }

    private String toCh(int d) {
        if (d >= 32 && d <= 127) {
            return "" + (char)d;
        }
        return "" + d;
    }

    private static String toHex(int v) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            if (h >= 10) {
                cb.append((char)(97 + h - 10));
                continue;
            }
            cb.append(h);
        }
        return cb.close();
    }
}

