/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.IiopReader;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class IOR {
    public static final int TAG_INTERNET_IOP = 0;
    public static final int TAG_MULTIPLE_COMPONENTS = 1;
    public static final int TAG_ORB_TYPE = 0;
    public static final int TAG_CODE_SETS = 1;
    public static final int TAG_POLICIES = 2;
    public static final int TAG_ALTERNATE_IIOP_ADDRESS = 3;
    public static final int TAG_ASSOCIATION_OPTIONS = 13;
    public static final int TAG_SEC_NAME = 14;
    public static final int TAG_SPKM_1_SEC_MECH = 15;
    public static final int TAG_SPKM_2_SEC_MECH = 16;
    public static final int TAG_KerberosV5_SEC_MECH = 17;
    public static final int TAG_CSI_ECMA_Secret_SEC_MECH = 18;
    public static final int TAG_CSI_ECMA_Hybrid_SEC_MECH = 19;
    public static final int TAG_SSL_SEC_TRANS = 20;
    public static final int TAG_ECMA_Public_SEC_MECH = 21;
    public static final int TAG_GENERIC_SEC_MECH = 22;
    public static final int TAG_JAVA_CODEBASE = 25;
    public static final int CS_ISO8859_1 = 65568;
    public static final int CS_UTF16 = 65792;
    String typeId;
    int major;
    int minor;
    String host;
    int port;
    byte[] oid;
    String uri;
    byte[] bytes;

    public IOR() {
    }

    public IOR(Class type, String host, int port, String uri) {
        this(type.getName(), host, port, uri);
    }

    public IOR(String typeId, String host, int port, String uri) {
        try {
            this.typeId = typeId;
            this.major = 1;
            this.minor = 2;
            this.host = host;
            this.port = port;
            this.uri = uri;
            this.oid = uri.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
    }

    public String getTypeId() {
        return this.typeId;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getOid() {
        return this.oid;
    }

    public String getURI() {
        if (this.uri == null) {
            if (this.oid == null) {
                return null;
            }
            try {
                this.uri = new String(this.oid, 0, this.oid.length, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.uri;
    }

    IOR read(IiopReader is) throws IOException {
        this.typeId = is.readString();
        int count = is.readInt();
        for (int i = 0; i < count; ++i) {
            int tag = is.readInt();
            if (tag != 0) {
                throw new RuntimeException("unsupported iop " + tag);
            }
            int sublen = is.readInt();
            int topEndian = is.read();
            this.major = is.read();
            this.minor = is.read();
            this.host = is.readString();
            this.port = is.read_short() & 0xFFFF;
            this.oid = is.readBytes();
            this.uri = null;
            if (this.minor < 1) continue;
            int tagCount = is.readInt();
            for (int j = 0; j < tagCount; ++j) {
                int compType = is.readInt();
                if (compType == 1) {
                    int len = is.readInt();
                    int endian = is.readInt();
                    int charCode = is.readInt();
                    sublen = is.readInt();
                    for (int k = 0; k < sublen; ++k) {
                        is.readInt();
                    }
                    int wcharCode = is.readInt();
                    sublen = is.readInt();
                    for (int k = 0; k < sublen; ++k) {
                        is.readInt();
                    }
                    continue;
                }
                byte[] bytes = is.readBytes();
            }
        }
        if (count == 0) {
            return null;
        }
        return this;
    }

    public void readByteArray(byte[] buf, int offset, int length) {
        int i = 0;
        int strlen = IOR.getInt(buf, offset + i);
        this.typeId = IOR.getString(buf, offset + (i += 4), strlen);
        i += strlen;
        i += (4 - i % 4) % 4;
        int len = IOR.getInt(buf, offset + i);
        i += 4;
        for (int k = 0; k < len; ++k) {
            int tag = IOR.getInt(buf, offset + i);
            i += 4;
            if (tag != 0) {
                throw new RuntimeException("unsupported iop " + tag);
            }
            int sublen = IOR.getInt(buf, offset + i);
            i += 4;
            this.major = buf[offset + i++] & 0xFF;
            this.minor = buf[offset + i++] & 0xFF;
            int startOff = offset;
            strlen = IOR.getInt(buf, offset + (i += 2));
            this.host = IOR.getString(buf, offset + (i += 4), strlen);
            i += strlen;
            i += i & 1;
            this.port = IOR.getShort(buf, offset + i);
            i += 2;
            i += (4 - i % 4) % 4;
            strlen = IOR.getInt(buf, offset + i);
            i += 4;
            this.uri = null;
            this.oid = new byte[strlen];
            for (int j = 0; j < strlen; ++j) {
                this.oid[j] = buf[offset + i + j];
            }
            i += strlen;
            i += (4 - i % 4) % 4;
        }
    }

    private static int getInt(byte[] buf, int offset) {
        return ((buf[offset] & 0xFF) << 24) + ((buf[offset + 1] & 0xFF) << 16) + ((buf[offset + 2] & 0xFF) << 8) + (buf[offset + 3] & 0xFF);
    }

    private static int getShort(byte[] buf, int offset) {
        return ((buf[offset] & 0xFF) << 8) + (buf[offset + 1] & 0xFF);
    }

    private static String getString(byte[] buf, int offset, int len) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < len - 1; ++i) {
            cb.append((char)buf[offset + i]);
        }
        return cb.close();
    }

    public byte[] getByteArray() {
        if (this.bytes != null) {
            return this.bytes;
        }
        ByteBuffer bb = new ByteBuffer();
        this.writeString(bb, this.typeId);
        this.align4(bb);
        bb.addInt(1);
        bb.addInt(0);
        int offset = bb.size();
        bb.addInt(0);
        bb.add(0);
        bb.add(this.major);
        bb.add(this.minor);
        this.writeString(bb, this.host);
        if ((bb.size() & 1) == 1) {
            bb.add(0);
        }
        bb.addShort(this.port);
        this.align4(bb);
        bb.addInt(this.oid.length);
        for (int i = 0; i < this.oid.length; ++i) {
            bb.add(this.oid[i]);
        }
        if (this.minor >= 1) {
            this.align4(bb);
            bb.addInt(1);
            bb.addInt(1);
            bb.addInt(20);
            bb.addInt(0);
            bb.addInt(65568);
            bb.addInt(0);
            bb.addInt(65792);
            bb.addInt(0);
        }
        bb.setInt(offset, bb.size() - offset - 4);
        this.bytes = bb.getByteArray();
        return this.bytes;
    }

    private void writeString(ByteBuffer bb, String str) {
        this.align4(bb);
        bb.addInt(str.length() + 1);
        for (int i = 0; i < str.length(); ++i) {
            bb.add(str.charAt(i));
        }
        bb.add(0);
    }

    private void align4(ByteBuffer bb) {
        int len = bb.getLength();
        int delta = (4 - len % 4) % 4;
        for (int i = 0; i < delta; ++i) {
            bb.add(0);
        }
    }

    public String toString() {
        return "IOR:" + this.typeId + "//" + this.host + ":" + this.port + "/" + this.bytesToHex(this.oid);
    }

    private static String toHex(int v) {
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            if (h >= 10) {
                cb.append((char)(97 + h - 10));
                continue;
            }
            cb.append(h);
        }
        return cb.close();
    }

    private static String toStr(int v) {
        int ch;
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 24; i >= 0 && (ch = v >> i & 0xFF) >= 32 && ch < 127; i -= 8) {
            cb.append((char)ch);
        }
        return cb.close();
    }

    private String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        CharBuffer cb = CharBuffer.allocate();
        for (int i = 0; i < bytes.length; ++i) {
            int ch1 = bytes[i] >> 4 & 0xF;
            int ch2 = bytes[i] & 0xF;
            if (ch1 < 10) {
                cb.append((char)(ch1 + 48));
            } else {
                cb.append((char)(ch1 + 97 - 10));
            }
            if (ch2 < 10) {
                cb.append((char)(ch2 + 48));
                continue;
            }
            cb.append((char)(ch2 + 97 - 10));
        }
        return cb.close();
    }
}

