/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractListDeserializer;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionDeserializer
extends AbstractListDeserializer {
    private Class _type;

    public CollectionDeserializer(Class type) {
        this._type = type;
    }

    public Class getType() {
        return this._type;
    }

    public Object readList(AbstractHessianInput in, int length) throws IOException {
        Collection list = null;
        if (this._type == null) {
            list = new ArrayList();
        } else if (!this._type.isInterface()) {
            try {
                list = (Collection)this._type.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (list == null) {
            if (ClassLiteral.getClass((String)"java/util/SortedSet").isAssignableFrom(this._type)) {
                list = new TreeSet();
            } else if (ClassLiteral.getClass((String)"java/util/Set").isAssignableFrom(this._type)) {
                list = new HashSet();
            } else if (ClassLiteral.getClass((String)"java/util/List").isAssignableFrom(this._type)) {
                list = new ArrayList();
            } else if (ClassLiteral.getClass((String)"java/util/Collection").isAssignableFrom(this._type)) {
                list = new ArrayList();
            } else {
                try {
                    list = (Collection)this._type.newInstance();
                }
                catch (Exception e) {
                    throw new IOException(String.valueOf(e));
                }
            }
        }
        in.addRef(list);
        while (!in.isEnd()) {
            list.add(in.readObject());
        }
        in.readEnd();
        return list;
    }
}

