/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.log.Log;
import com.caucho.util.IntMap;
import com.caucho.util.L10N;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class ThrottleFilter
implements Filter {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/filters/ThrottleFilter"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/filters/ThrottleFilter"));
    private IntMap _throttleCache = new IntMap();
    private int _maxConcurrentRequests = 2;

    public void setMaxConcurrentRequests(int max) {
        this._maxConcurrentRequests = max;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        boolean isOverflow;
        int count;
        String ip = request.getRemoteAddr();
        ThrottleFilter throttleFilter = this;
        synchronized (throttleFilter) {
            count = this._throttleCache.get(ip);
            if (count <= 0) {
                count = 0;
            }
            if (count < this._maxConcurrentRequests) {
                isOverflow = false;
                this._throttleCache.put(ip, count + 1);
            } else {
                isOverflow = true;
            }
        }
        if (isOverflow) {
            log.info(L.l("'{0}' has too many concurrent requests -- throttling.", ip));
            if (response instanceof HttpServletResponse) {
                ((HttpServletResponse)response).sendError(503);
            }
            return;
        }
        try {
            nextFilter.doFilter(request, response);
        }
        finally {
            throttleFilter = this;
            synchronized (throttleFilter) {
                count = this._throttleCache.get(ip);
                if (count <= 1) {
                    this._throttleCache.remove(ip);
                } else {
                    this._throttleCache.put(ip, count - 1);
                }
            }
        }
    }

    public void destroy() {
    }
}

