/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.filters;

import com.caucho.config.types.Period;
import com.caucho.log.Log;
import com.caucho.server.cluster.Cluster;
import com.caucho.server.cluster.ClusterContainer;
import com.caucho.server.cluster.ClusterServer;
import com.caucho.server.cluster.ClusterStream;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.util.Alarm;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class HmuxDispatchFilter
implements Filter {
    private static final L10N L = new L10N(ClassLiteral.getClass((String)"com/caucho/filters/HmuxDispatchFilter"));
    private static final Logger log = Log.open(ClassLiteral.getClass((String)"com/caucho/filters/HmuxDispatchFilter"));
    private static Entry _mismatchEntry = new Entry(false);
    private HashMap<String, HostEntry> _hostMap = new HashMap();
    private long _lastUpdateTime;
    private long _updateInterval = 15000L;
    private String _mapETag;
    private FilterConfig _config;
    private ServletContext _application;
    private RequestDispatcher _remote;
    private String _clusterId;
    private Cluster _cluster;
    private ClusterServer[] _srunGroup;

    public void setClusterId(String id) {
        this._clusterId = id;
    }

    public void setUpdateInterval(Period period) {
        this._updateInterval = period.getPeriod();
    }

    public void init(FilterConfig config) throws ServletException {
        this._config = config;
        this._application = config.getServletContext();
        this._remote = this._application.getNamedDispatcher("remote");
        if (this._remote == null) {
            throw new ServletException(L.l("`remote' servlet must be configured so HmuxDispatchFilter can dispatch to the backend."));
        }
        String clusterId = config.getInitParameter("cluster");
        if (clusterId != null) {
            this._clusterId = clusterId;
        }
        if (this._clusterId == null) {
            throw new ServletException("HmuxDispatchFilter needs valid cluster");
        }
        ClusterContainer clusterContainer = ClusterContainer.getLocal();
        if (clusterContainer != null) {
            this._cluster = clusterContainer.findCluster(this._clusterId);
        }
        if (this._cluster == null) {
            throw new ServletException("HmuxDispatchFilter needs valid cluster");
        }
        this._srunGroup = this._cluster.getServerList();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain nextFilter) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        if (this.isDispatch(req.getServerName(), req.getServerPort(), req.getRequestURI())) {
            this._remote.forward(request, response);
        } else {
            nextFilter.doFilter(request, response);
        }
    }

    public boolean isDispatch(String serverName, int serverPort, String uri) {
        try {
            return this.isDispatchRemote(serverName, serverPort, uri);
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            return false;
        }
    }

    public boolean isDispatchRemote(String host, int port, String uri) throws IOException {
        long now = Alarm.getCurrentTime();
        HostEntry hostEntry = this.getHostEntry(host + ':' + port, uri);
        if (hostEntry == null) {
            return false;
        }
        AppEntry appEntry = hostEntry.getAppEntry(uri);
        if (appEntry == null) {
            return false;
        }
        String tail = uri.substring(appEntry.getContextPath().length());
        Entry entry = appEntry.findPattern(tail);
        if (entry == null) {
            return false;
        }
        return entry.isDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostEntry getHostEntry(String host, String url) {
        HostEntry entry = this._hostMap.get(host);
        long now = Alarm.getCurrentTime();
        HashMap<String, HostEntry> hashMap = this._hostMap;
        synchronized (hashMap) {
            if (entry != null && entry.getLastModified() + this._updateInterval < now) {
                return entry;
            }
            if (entry == null) {
                entry = new HostEntry(host);
                this._hostMap.put(host, entry);
            }
            entry.setLastModified(now);
        }
        ClusterServer srun = null;
        for (int i = 0; i < this._srunGroup.length && (srun = this._srunGroup[i]) == null; ++i) {
        }
        if (srun == null) {
            return entry;
        }
        ClusterStream stream = null;
        stream = srun.getClient().openRecycle();
        if (stream == null) {
            stream = srun.getClient().open();
        }
        ReadStream rs = stream.getReadStream();
        WriteStream ws = stream.getWriteStream();
        boolean keepalive = false;
        try {
            HostEntry hostEntry;
            int channel = 2;
            ws.write(67);
            ws.write(channel >> 8);
            ws.write(channel);
            this.writeInt(ws, 80, 258);
            this.writeString(ws, 104, host);
            this.writeString(ws, 113, url);
            String etag = entry.getETag();
            if (etag != null) {
                this.writeString(ws, 101, etag);
            }
            ws.write(81);
            int code = rs.read();
            if (code != 67) {
                log.warning("Hmux protocol error at " + (char)code);
                HostEntry hostEntry2 = entry;
                return hostEntry2;
            }
            int outChannel = (rs.read() << 8) + rs.read();
            if (outChannel != 2) {
                HostEntry hostEntry3 = entry;
                return hostEntry3;
            }
            HashMap<String, AppEntry> appMap = new HashMap<String, AppEntry>();
            AppEntry appEntry = null;
            while ((code = rs.read()) >= 0) {
                switch (code) {
                    case 81: {
                        entry.setAppMap(appMap);
                        keepalive = true;
                        hostEntry = entry;
                        return hostEntry;
                    }
                    case 88: {
                        entry.setAppMap(appMap);
                        keepalive = false;
                        hostEntry = entry;
                        return hostEntry;
                    }
                    case 104: {
                        String canonicalHost = this.readString(rs);
                        log.finer("host: " + canonicalHost);
                        if (canonicalHost.equals(host)) break;
                        HostEntry canonicalEntry = this.getHostEntry(canonicalHost, url);
                        entry.setCanonicalHost(canonicalEntry);
                        break;
                    }
                    case 97: {
                        String contextPath = this.readString(rs);
                        appEntry = new AppEntry(contextPath);
                        appMap.put(contextPath, appEntry);
                        log.finer("web-app: " + contextPath);
                        break;
                    }
                    case 101: {
                        String newETag = this.readString(rs);
                        if (this._mapETag != null && this._mapETag.equals(newETag)) {
                            appMap = entry.getAppMap();
                        }
                        this._mapETag = newETag;
                        break;
                    }
                    case 109: {
                        String pattern = this.readString(rs);
                        appEntry.addMatch(pattern);
                        log.finer("match: " + pattern);
                        break;
                    }
                    case 105: {
                        String pattern = this.readString(rs);
                        appEntry.addIgnore(pattern);
                        log.finer("ignore: " + pattern);
                        break;
                    }
                    case 72: {
                        String header = this.readString(rs);
                        int ch = rs.read();
                        if (ch != 83) {
                            log.warning("Hmux protocol error at " + (char)code);
                            HostEntry hostEntry4 = entry;
                            return hostEntry4;
                        }
                        String value = this.readString(rs);
                        log.finer(header + ": " + value);
                        break;
                    }
                    case 99: {
                        String value = this.readString(rs);
                        log.finer("cluster: " + value);
                        break;
                    }
                    case 115: {
                        String value = this.readString(rs);
                        log.finer("srun: " + value);
                        break;
                    }
                    default: {
                        log.warning("Hmux protocol error at " + (char)code);
                        HostEntry hostEntry5 = entry;
                        return hostEntry5;
                    }
                }
            }
            hostEntry = entry;
            return hostEntry;
        }
        catch (IOException e) {
            log.log(Level.WARNING, e.toString(), e);
            HostEntry hostEntry = entry;
            return hostEntry;
        }
        finally {
            if (keepalive) {
                stream.free();
            } else {
                stream.close();
            }
        }
    }

    private void writeString(WriteStream ws, int code, String value) throws IOException {
        int len = value.length();
        ws.write(code);
        ws.write(len >> 8);
        ws.write(len);
        ws.print(value);
    }

    private String readString(ReadStream rs) throws IOException {
        int len = (rs.read() << 8) + rs.read();
        if (len < 0 || len > 65535) {
            throw new IOException("PROTOCOL");
        }
        CharBuffer cb = CharBuffer.allocate();
        rs.readAll(cb, len);
        return cb.close();
    }

    private void writeInt(WriteStream ws, int code, int value) throws IOException {
        ws.write(code);
        ws.write(0);
        ws.write(4);
        ws.write(value >> 24);
        ws.write(value >> 16);
        ws.write(value >> 8);
        ws.write(value);
    }

    public void destroy() {
    }

    static class Entry {
        private boolean _isDispatch;

        Entry(boolean isDispatch) {
            this._isDispatch = isDispatch;
        }

        public void setDispatch(boolean isDispatch) {
            this._isDispatch = isDispatch;
        }

        public boolean isDispatch() {
            return this._isDispatch;
        }
    }

    static class AppEntry {
        private String _contextPath;
        private UrlMap<Entry> _urlMap = new UrlMap();

        public AppEntry(String path) {
            this._contextPath = path;
        }

        public String getContextPath() {
            return this._contextPath;
        }

        public Entry addMatch(String urlPattern) {
            Entry entry = new Entry(true);
            this._urlMap.addMap(urlPattern, entry);
            return entry;
        }

        public Entry addIgnore(String urlPattern) {
            Entry entry = new Entry(false);
            this._urlMap.addMap(urlPattern, entry);
            return entry;
        }

        public Entry findPattern(String urlPattern) {
            return this._urlMap.map(urlPattern);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HostEntry {
        private String _hostName;
        private HostEntry _canonicalHost;
        private HashMap<String, AppEntry> _appMap;
        private String _etag;
        private long _lastModified;

        public HostEntry(String hostName) {
            this._hostName = hostName;
        }

        public long getLastModified() {
            return this._lastModified;
        }

        public void setLastModified(long lastModified) {
            this._lastModified = lastModified;
        }

        public String getETag() {
            return this._etag;
        }

        public void setETag(String etag) {
            this._etag = etag;
        }

        public void setCanonicalHost(HostEntry host) {
            this._canonicalHost = host;
        }

        public HostEntry getCanonicalHost() {
            return this._canonicalHost;
        }

        public HashMap<String, AppEntry> getAppMap() {
            return this._appMap;
        }

        public void setAppMap(HashMap<String, AppEntry> appMap) {
            this._appMap = appMap;
        }

        public void addWebApp(String contentPath, AppEntry entry) {
            if (this._appMap == null) {
                this._appMap = new HashMap();
            }
            this._appMap.put(contentPath, entry);
        }

        public AppEntry getAppEntry(String uri) {
            if (this._canonicalHost != null) {
                return this._canonicalHost.getAppEntry(uri);
            }
            if (this._appMap == null) {
                return null;
            }
            HashMap<String, AppEntry> appMap = this._appMap;
            int tail = uri.length();
            while (tail >= 0) {
                String prefix = uri.substring(0, tail);
                AppEntry appEntry = appMap.get(prefix);
                if (appEntry != null) {
                    return appEntry;
                }
                tail = uri.lastIndexOf(47, tail - 1);
            }
            return null;
        }
    }
}

